/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.conan;

import com.google.common.base.Preconditions;
import com.sonatype.repository.conan.AssetKind;
import com.sonatype.repository.conan.ConanAssetHelper;
import com.sonatype.repository.conan.ConanContentFacet;
import com.sonatype.repository.conan.ConanCoords;
import java.io.IOException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.restore.datastore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.datastore.DataStoreRestoreBlobData;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.DetachedBlobPayload;

@FeatureFlag(name="nexus.datastore.enabled")
@Named(value="conan")
@Singleton
public class ConanRestoreBlobStrategy
extends BaseRestoreBlobStrategy<DataStoreRestoreBlobData> {
    private static final Pattern PROJECT_VERSION_GROUP = Pattern.compile("/conans/(?<project>[^/]+)/(?<version>[^/]+)/(?<group>[^/]+)/(?<channel>[^/]+)?(/packages/(?<sha>[^/]+))?.*");
    private static final Pattern GROUP_PROJECT_VERSION = Pattern.compile("/conans/(?<group>[^/]+)/(?<project>[^/]+)/(?<version>[^/]+)/(?<channel>[^/]+)?(/packages/(?<sha>[^/]+))?.*");
    private static final Pattern PACKAGE_SNAPSHOT = Pattern.compile("/conans/[^/]+/[^/]+/[^/]+/[^/]+/packages/[0-9a-f]+");
    private final RepositoryManager repositoryManager;

    @Inject
    public ConanRestoreBlobStrategy(DryRunPrefix dryRunPrefix, RepositoryManager repositoryManager) {
        super(dryRunPrefix);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    public void after(boolean updateAssets, Repository repository) {
    }

    protected boolean canAttemptRestore(@Nonnull DataStoreRestoreBlobData data) {
        Repository repository = data.getRepository();
        if (!repository.optionalFacet(ConanContentFacet.class).isPresent()) {
            this.log.warn("Skipping as Conan Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        if (this.getKindCoords((DataStoreRestoreBlobData)data).coords == null) {
            this.log.warn("Skipping as unable to determine coordinates: {}", (Object)this.getAssetPath(data));
            return false;
        }
        return true;
    }

    protected void createAssetFromBlob(Blob assetBlob, DataStoreRestoreBlobData data) throws IOException {
        ConanContentFacet contentFacet = (ConanContentFacet)data.getRepository().facet(ConanContentFacet.class);
        KindCoords kindCoords = this.getKindCoords(data);
        contentFacet.putPackage((Payload)new DetachedBlobPayload(assetBlob), kindCoords.coords, kindCoords.assetKind);
    }

    static AssetKind getAssetKind(String assetPath) {
        if (PACKAGE_SNAPSHOT.matcher(assetPath).matches()) {
            return AssetKind.CONAN_PACKAGE_SNAPSHOT;
        }
        String fileName = assetPath.substring(assetPath.lastIndexOf(47) + 1);
        return AssetKind.valueFromFileName((String)fileName);
    }

    ConanCoords getCoords(String assetPath, AssetKind assetKind) {
        Pattern pattern = ConanAssetHelper.DOWNLOAD_ASSET_KINDS.contains(assetKind) ? PROJECT_VERSION_GROUP : GROUP_PROJECT_VERSION;
        Matcher matcher = pattern.matcher(assetPath);
        if (matcher.matches()) {
            return new ConanCoords("conans", matcher.group("group"), matcher.group("project"), matcher.group("version"), matcher.group("channel"), matcher.group("sha"));
        }
        this.log.error("Unable to parse asset path to Conan coordinates: '{}'", (Object)assetPath);
        return null;
    }

    private KindCoords getKindCoords(DataStoreRestoreBlobData data) {
        String assetPath = this.getAssetPath(data);
        AssetKind assetKind = ConanRestoreBlobStrategy.getAssetKind(assetPath);
        ConanCoords coords = this.getCoords(assetPath, assetKind);
        return new KindCoords(assetKind, coords);
    }

    protected String getAssetPath(@Nonnull DataStoreRestoreBlobData data) {
        return data.getBlobName();
    }

    protected DataStoreRestoreBlobData createRestoreData(Properties properties, Blob blob, BlobStore blobStore) {
        return new DataStoreRestoreBlobData(blob, properties, blobStore, this.repositoryManager);
    }

    protected boolean isComponentRequired(DataStoreRestoreBlobData data) {
        return true;
    }

    private static class KindCoords {
        public final AssetKind assetKind;
        public final ConanCoords coords;

        public KindCoords(AssetKind assetKind, ConanCoords coords) {
            this.assetKind = assetKind;
            this.coords = coords;
        }
    }
}

