/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.token;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.security.UserPrincipalsHelper;
import org.sonatype.nexus.security.authc.NexusApiKeyAuthenticationToken;
import org.sonatype.nexus.security.authc.apikey.ApiKeyStore;
import org.sonatype.nexus.security.user.UserNotFoundException;

public abstract class BearerTokenRealm
extends AuthenticatingRealm {
    public static final String IS_TOKEN_AUTH_KEY = String.valueOf(BearerTokenRealm.class.getName()) + ".IS_TOKEN";
    @VisibleForTesting
    static final String ANONYMOUS_USER = "anonymous";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final ApiKeyStore keyStore;
    private final UserPrincipalsHelper principalsHelper;
    private final String format;
    private Provider<HttpServletRequest> requestProvider;

    public BearerTokenRealm(ApiKeyStore keyStore, UserPrincipalsHelper principalsHelper, String format) {
        this.keyStore = (ApiKeyStore)Preconditions.checkNotNull((Object)keyStore);
        this.principalsHelper = (UserPrincipalsHelper)((Object)Preconditions.checkNotNull((Object)((Object)principalsHelper)));
        this.format = (String)Preconditions.checkNotNull((Object)format);
        this.setName(format);
        this.setAuthenticationCachingEnabled(false);
    }

    @Inject
    private void setRequestProvider(Provider<HttpServletRequest> requestProvider) {
        this.requestProvider = (Provider)Preconditions.checkNotNull(requestProvider);
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof NexusApiKeyAuthenticationToken && this.format.equals(token.getPrincipal());
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) {
        Preconditions.checkNotNull((Object)token);
        PrincipalCollection principals = this.keyStore.getPrincipals(this.format, (char[])token.getCredentials());
        if (principals != null) {
            try {
                if (this.anonymousAndSupported(principals) || this.principalsHelper.getUserStatus(principals).isActive()) {
                    ((NexusApiKeyAuthenticationToken)token).setPrincipal(principals.getPrimaryPrincipal());
                    if (this.requestProvider != null) {
                        ((HttpServletRequest)this.requestProvider.get()).setAttribute(IS_TOKEN_AUTH_KEY, (Object)Boolean.TRUE);
                    }
                    return new SimpleAuthenticationInfo(principals, token.getCredentials());
                }
            }
            catch (UserNotFoundException e) {
                this.log.debug("Realm did not find user", (Throwable)e);
                this.keyStore.deleteApiKeys(principals);
            }
        }
        return null;
    }

    @Nullable
    protected Object getAuthenticationCacheKey(@Nullable AuthenticationToken token) {
        PrincipalCollection principals;
        if (token != null && (principals = this.keyStore.getPrincipals(this.format, (char[])token.getCredentials())) != null) {
            return principals.getPrimaryPrincipal();
        }
        return null;
    }

    protected boolean isAnonymousSupported() {
        return false;
    }

    private boolean anonymousAndSupported(PrincipalCollection principals) {
        return ANONYMOUS_USER.equals(principals.getPrimaryPrincipal()) && this.isAnonymousSupported();
    }
}

