/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.privilege.rest;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public enum PrivilegeAction {
    READ("read"),
    BROWSE("browse"),
    EDIT("edit"),
    ADD("add"),
    DELETE("delete"),
    RUN("run"),
    ASSOCIATE("associate"),
    DISASSOCIATE("disassociate"),
    ALL("*");

    private final String action;

    private PrivilegeAction(String action) {
        this.action = action;
    }

    @Nullable
    public String getBreadAction() {
        switch (this) {
            case READ: 
            case BROWSE: 
            case EDIT: 
            case ADD: 
            case DELETE: 
            case ALL: {
                return this.action;
            }
        }
        return null;
    }

    @Nullable
    public String getBreadRunAction() {
        switch (this) {
            case READ: 
            case BROWSE: 
            case EDIT: 
            case ADD: 
            case DELETE: 
            case RUN: 
            case ALL: {
                return this.action;
            }
        }
        return null;
    }

    @Nullable
    public String getCrudAction() {
        switch (this) {
            case ADD: {
                return "create";
            }
            case EDIT: {
                return "update";
            }
            case READ: 
            case DELETE: 
            case ASSOCIATE: 
            case DISASSOCIATE: 
            case ALL: {
                return this.action;
            }
        }
        return null;
    }

    @Nullable
    public static PrivilegeAction fromAction(String action) {
        String trimmed;
        switch (trimmed = action.trim()) {
            case "create": {
                return ADD;
            }
            case "update": {
                return EDIT;
            }
        }
        return Arrays.stream(PrivilegeAction.values()).filter(a -> a.action.equals(action)).findFirst().orElse(null);
    }

    public static List<PrivilegeAction> getBreadActions() {
        return Arrays.asList(BROWSE, READ, EDIT, ADD, DELETE, ALL);
    }

    public static List<PrivilegeAction> getBreadRunActions() {
        return Arrays.asList(BROWSE, READ, EDIT, ADD, DELETE, RUN, ALL);
    }

    public static List<PrivilegeAction> getCrudActions() {
        return Arrays.asList(READ, EDIT, ADD, DELETE, ASSOCIATE, DISASSOCIATE, ALL);
    }
}

