/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.jwt.rest;

import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.distributed.event.service.api.DistributedEvent;
import org.sonatype.nexus.distributed.event.service.api.common.JWTSecretChangedEvent;
import org.sonatype.nexus.distributed.event.service.api.common.PublisherEvent;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.security.jwt.JwtSecretChanged;
import org.sonatype.nexus.security.jwt.SecretStore;
import org.sonatype.nexus.security.jwt.rest.JwtSecretApiResourceDoc;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/v1/security/jwt")
@Named
@Singleton
public class JwtSecretApiResourceV1
extends ComponentSupport
implements Resource,
JwtSecretApiResourceDoc {
    public static final String PATH = "/v1/security/jwt";
    private final SecretStore secretStore;
    private final EventManager eventManager;

    @Inject
    public JwtSecretApiResourceV1(SecretStore secretStore, EventManager eventManager) {
        this.secretStore = (SecretStore)Preconditions.checkNotNull((Object)secretStore);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    public Response resetSecret() {
        String secret = UUID.randomUUID().toString();
        this.secretStore.setSecret(secret);
        this.eventManager.post((Object)new JwtSecretChanged(secret));
        this.eventManager.post((Object)new PublisherEvent((DistributedEvent)new JWTSecretChangedEvent()));
        return Response.status((Response.Status)Response.Status.OK).build();
    }
}

