/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.security.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.security.realm.RealmConfiguration;
import org.sonatype.nexus.security.realm.RealmConfigurationChangedEvent;

@Named
@Singleton
public class RealmAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "security.realm";

    @Subscribe
    @AllowConcurrentEvents
    public void on(RealmConfigurationChangedEvent event) {
        if (this.isRecording()) {
            RealmConfiguration configuration = event.getConfiguration();
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType("changed");
            data.setContext("system");
            Map attributes = data.getAttributes();
            attributes.put("realms", RealmAuditor.string(configuration.getRealmNames()));
            this.record(data);
        }
    }
}

