/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.v3;

import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.PackageBaseAddress;
import com.sonatype.nexus.repository.nuget.v3.RegistrationsBaseUrl;
import com.sonatype.nexus.repository.nuget.v3.SearchQueryService;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.FacetSupport;

public class NugetV3ServiceIndexFacetImpl
extends FacetSupport
implements NugetV3ServiceIndexFacet {
    @Override
    public ServiceIndex getServiceIndex() {
        ServiceIndex serviceIndex = new ServiceIndex();
        serviceIndex.setVersion(this.getServiceVersion());
        serviceIndex.setResources(this.getServiceResources());
        return serviceIndex;
    }

    protected List<ServiceResource> getServiceResources() {
        ArrayList<ServiceResource> serviceResources = new ArrayList<ServiceResource>();
        serviceResources.addAll(this.getPackageBaseAddressResources());
        serviceResources.addAll(this.getSearchQueryServiceResources());
        serviceResources.addAll(this.getRegistrationBaseUrlResources());
        serviceResources.addAll(this.getOtherServiceResources());
        return serviceResources;
    }

    protected List<ServiceResource> getPackageBaseAddressResources() {
        return Collections.singletonList(this.buildResource(PackageBaseAddress.PACKAGE_BASE_ADDRESS));
    }

    protected List<ServiceResource> getSearchQueryServiceResources() {
        return Arrays.stream(SearchQueryService.values()).map(this::buildResource).collect(Collectors.toList());
    }

    protected List<ServiceResource> getRegistrationBaseUrlResources() {
        return Arrays.stream(RegistrationsBaseUrl.values()).map(this::buildResource).collect(Collectors.toList());
    }

    protected List<ServiceResource> getOtherServiceResources() {
        return Collections.emptyList();
    }

    protected String getServiceVersion() {
        return "3.0.0";
    }

    protected ServiceResource buildResource(NugetServiceType serviceType) {
        String serviceTypePath = StringUtils.prependIfMissing((String)serviceType.getPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        String id = String.valueOf(this.getRepository().getUrl()) + serviceTypePath;
        return this.buildResource(serviceType.getType(), id);
    }

    protected ServiceResource buildResource(String type, String id) {
        ServiceResource serviceResource = new ServiceResource();
        serviceResource.setId(id);
        serviceResource.setType(type);
        return serviceResource;
    }

    @Override
    public void removeServiceIndex() {
    }
}

