/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.rest.datastore;

import com.sonatype.nexus.repository.nuget.NugetVersion;
import com.sonatype.nexus.repository.nuget.rest.NugetProxyRepositoryApiRequest;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.rest.api.ProxyRepositoryApiRequestToConfigurationConverter;
import org.sonatype.nexus.repository.rest.api.model.ProxyRepositoryApiRequest;
import org.sonatype.nexus.repository.routing.RoutingRuleStore;

@Named
public class NugetProxyRepositoryApiRequestToConfigurationConverter
extends ProxyRepositoryApiRequestToConfigurationConverter<NugetProxyRepositoryApiRequest> {
    @Inject
    public NugetProxyRepositoryApiRequestToConfigurationConverter(RoutingRuleStore routingRuleStore) {
        super(routingRuleStore);
    }

    public Configuration convert(NugetProxyRepositoryApiRequest request) {
        if (NugetVersion.V2 == request.getNugetProxy().getNugetVersion()) {
            throw new UnsupportedOperationException("NuGet V2 is deprecated and not supported in this version of NXRM3");
        }
        Configuration configuration = super.convert((ProxyRepositoryApiRequest)request);
        configuration.attributes("nugetProxy").set("queryCacheItemMaxAge", (Object)request.getNugetProxy().getQueryCacheItemMaxAge());
        return configuration;
    }
}

