/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v3.packagemetadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata.NugetRegistrationsFacet;
import com.sonatype.nexus.repository.nuget.orient.OrientNugetComponentHelper;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetUtils;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.ComponentEvent;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Priority(value=0x7FFFFFFF)
@Named
public class OrientNugetRegistrationsFacet
extends NugetRegistrationsFacet {
    @Inject
    public OrientNugetRegistrationsFacet(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    @TransactionalTouchBlob
    protected Collection<NugetRegistrationsFacet.ComponentContainer> getComponents(String packageId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return OrientNugetComponentHelper.findComponentByNameCaseInsensitive(packageId, tx, this.getRepository()).stream().map(component -> {
            Asset firstAsset = tx.firstAsset(component);
            if (firstAsset == null) {
                return null;
            }
            NestedAttributesMap formatAttributes = firstAsset.formatAttributes();
            return new NugetRegistrationsFacet.ComponentContainer(component.name(), component.requireVersion(), formatAttributes);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    @TransactionalTouchBlob
    protected Optional<NugetRegistrationsFacet.ComponentContainer> getComponent(NugetPackageCoords coords) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return Optional.ofNullable(OrientNugetComponentHelper.findComponent(tx, coords.getId(), coords.getVersion(), Collections.singletonList(this.getRepository()))).map(component -> {
            Asset firstAsset = tx.firstAsset(component);
            if (firstAsset == null) {
                return null;
            }
            NestedAttributesMap formatAttributes = firstAsset.formatAttributes();
            return new NugetRegistrationsFacet.ComponentContainer(component.name(), component.requireVersion(), formatAttributes);
        });
    }

    @Override
    @TransactionalTouchBlob
    protected Optional<RegistrationIndex> getCachedRegistrationIndex(String packageId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Repository repository = this.getRepository();
        Asset regIndexAsset = OrientNugetAssetUtils.findAssetWithName(tx, this.registrationIndexName(packageId), repository);
        if (regIndexAsset == null) {
            return Optional.empty();
        }
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (InputStream is = tx.requireBlob(regIndexAsset.requireBlobRef()).getInputStream();){
                RegistrationIndex registrationIndex = (RegistrationIndex)this.mapper.readValue(is, RegistrationIndex.class);
                return Optional.of(registrationIndex);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            this.log.warn("Unable to read cached registration index for package: {} in repository: {}", (Object)packageId, (Object)repository.getName());
            return Optional.empty();
        }
    }

    @Override
    protected void storePayload(Payload payload, String contentName) throws IOException {
        OrientNugetAssetUtils.storePayload(this.getRepository(), payload, contentName);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(ComponentEvent event) {
        if (event.isLocal() && this.getRepository().getName().equals(event.getRepositoryName())) {
            Transactional.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).run(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Asset regIndexAsset = OrientNugetAssetUtils.findAssetWithName(tx, this.registrationIndexName(event.getComponent().name()), this.getRepository());
                if (regIndexAsset != null) {
                    tx.deleteAsset(regIndexAsset);
                }
            });
        }
    }
}

