/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyRepositorySignaturesFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetUtils;
import com.sonatype.nexus.repository.nuget.v3.models.Certificate;
import com.sonatype.nexus.repository.nuget.v3.models.RepositorySignaturesIndex;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Facet.Exposed
public class OrientNugetV3ProxyRepositorySignaturesFacet
extends FacetSupport
implements NugetV3ProxyRepositorySignaturesFacet {
    private final ObjectMapper objectMapper;

    @Inject
    public OrientNugetV3ProxyRepositorySignaturesFacet(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    @TransactionalTouchBlob
    public Optional<Asset> getRepositorySignaturesIndexAsset(String assetPath) {
        Repository repository = this.getRepository();
        return Optional.ofNullable(OrientNugetAssetUtils.findAssetWithName(this.storageTx(), assetPath, repository));
    }

    @Override
    @TransactionalTouchBlob
    public Optional<RepositorySignaturesIndex> getRepositorySignaturesIndex(String assetPath) {
        Optional<Asset> assetOptional = this.getRepositorySignaturesIndexAsset(NugetV3ProxyUtil.trimSlashes(assetPath));
        return assetOptional.filter(asset -> asset.blobRef() != null).map(asset -> {
            Content content = OrientNugetAssetUtils.toContent(asset, this.storageTx().requireBlob(asset.requireBlobRef()));
            return this.serializeRepositorySignaturesIndex((Payload)content);
        });
    }

    @Override
    public Optional<Certificate> getRepositorySignaturesCertificate(RepositorySignaturesIndex repositorySignaturesIndex, String certificateFingerprint) {
        return repositorySignaturesIndex.getSigningCertificates().stream().filter(certificate -> certificate.getFingerprints().getValue().equals(certificateFingerprint)).findAny();
    }

    private StorageTx storageTx() {
        return (StorageTx)UnitOfWork.currentTx();
    }

    @Override
    public Content rewriteRepositorySignaturesIndex(Content content, String repositorySignaturesPath) {
        RepositorySignaturesIndex repositorySignaturesIndex = this.serializeRepositorySignaturesIndex((Payload)content);
        NugetV3ProxyUtil.rewriteRepositorySignaturesIndex(repositorySignaturesIndex, repositorySignaturesPath, this.getRepository().getUrl());
        byte[] body = this.deserializeRepositorySignaturesIndex(repositorySignaturesIndex);
        BytesPayload bytesPayload = new BytesPayload(body, content.getContentType());
        Content newContent = new Content((Payload)bytesPayload);
        newContent.getAttributes().backing().putAll(content.getAttributes().backing());
        return newContent;
    }

    private byte[] deserializeRepositorySignaturesIndex(RepositorySignaturesIndex repositorySignaturesIndex) {
        try {
            return this.objectMapper.writeValueAsBytes((Object)repositorySignaturesIndex);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private RepositorySignaturesIndex serializeRepositorySignaturesIndex(Payload payload) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = payload.openInputStream();){
                return (RepositorySignaturesIndex)this.objectMapper.readValue(inputStream, RepositorySignaturesIndex.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

