/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyRepositorySignaturesFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetContentMatcher;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetMetadataMatcher;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.orient.OrientNugetComponentHelper;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetUtils;
import com.sonatype.nexus.repository.nuget.orient.internal.v3.OrientNugetV3ProxyRepositorySignaturesFacet;
import com.sonatype.nexus.repository.nuget.orient.internal.v3.packagemetadata.OrientPackageMetadataFacet;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class OrientNugetV3FacetSupport
extends FacetSupport {
    @Nullable
    @TransactionalTouchBlob
    public Content getItem(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        boolean returnsOriginal = this.getReturnsOriginalContentParam(context);
        switch (assetKind) {
            case SERVICE_INDEX: {
                return this.getServiceIndexContent();
            }
            case REGISTRATION_INDEX: {
                return ((OrientPackageMetadataFacet)this.facet(OrientPackageMetadataFacet.class)).getRegistrationIndex(OrientNugetAssetUtils.assetName(context), (ServiceIndex)context.getAttributes().require(ServiceIndex.class), returnsOriginal);
            }
            case REGISTRATION_PAGE: 
            case REGISTRATION_LEAF: {
                String assetName = OrientNugetAssetUtils.assetName(context);
                Asset asset = this.findAsset(assetName);
                if (asset == null) {
                    return null;
                }
                Content storedContent = OrientNugetAssetUtils.toContent(asset, this.storageTx().requireBlob(asset.requireBlobRef()));
                if (returnsOriginal) {
                    return storedContent;
                }
                return this.rewriteRegistrationContent(assetKind, assetName, storedContent);
            }
            case CONTENT: {
                Asset asset = this.findComponentAsset(context);
                if (asset == null || asset.blobRef() == null) {
                    return null;
                }
                return OrientNugetAssetUtils.toContent(asset, this.storageTx().requireBlob(asset.requireBlobRef()));
            }
            case REPOSITORY_SIGNATURES: {
                return this.getRepositorySignatures(context);
            }
        }
        Asset asset = this.findAsset(OrientNugetAssetUtils.assetName(context));
        return asset == null ? null : OrientNugetAssetUtils.toContent(asset, this.storageTx().requireBlob(asset.requireBlobRef()));
    }

    @Nullable
    private Content getRepositorySignatures(Context context) {
        NugetV3ProxyRepositorySignaturesFacet facet = (NugetV3ProxyRepositorySignaturesFacet)context.getRepository().facet(NugetV3ProxyRepositorySignaturesFacet.class);
        String assetPath = OrientNugetAssetUtils.assetName(context);
        Asset repositorySignaturesIndexAsset = ((OrientNugetV3ProxyRepositorySignaturesFacet)this.facet(OrientNugetV3ProxyRepositorySignaturesFacet.class)).getRepositorySignaturesIndexAsset(assetPath).orElse(null);
        if (repositorySignaturesIndexAsset == null) {
            return null;
        }
        Content content = OrientNugetAssetUtils.toContent(repositorySignaturesIndexAsset, this.storageTx().requireBlob(repositorySignaturesIndexAsset.requireBlobRef()));
        String repositorySignaturesPath = NugetMetadataMatcher.getRepositorySignaturesPath(context);
        return facet.rewriteRepositorySignaturesIndex(content, repositorySignaturesPath);
    }

    public Content storeItem(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        boolean returnsOriginal = this.getReturnsOriginalContentParam(context);
        switch (assetKind) {
            case SERVICE_INDEX: {
                return this.storeServiceIndex(content);
            }
            case REGISTRATION_INDEX: 
            case REGISTRATION_PAGE: 
            case REGISTRATION_LEAF: {
                Content storedContent = OrientNugetAssetUtils.storeContent(this.getRepository(), content, OrientNugetAssetUtils.assetName(context));
                if (returnsOriginal) {
                    return storedContent;
                }
                return this.rewriteRegistrationContent(assetKind, OrientNugetAssetUtils.assetName(context), storedContent);
            }
            case CONTENT: {
                return this.storePackageContent(context, content);
            }
            case REPOSITORY_SIGNATURES: {
                return this.storeRepositorySignature(context, content);
            }
        }
        return OrientNugetAssetUtils.storeContent(this.getRepository(), content, OrientNugetAssetUtils.assetName(context));
    }

    private Content storeRepositorySignature(Context context, Content content) throws IOException {
        String assetPath = OrientNugetAssetUtils.assetName(context);
        Content storedContent = OrientNugetAssetUtils.storeContent(this.getRepository(), content, assetPath);
        String repositorySignaturesPath = NugetMetadataMatcher.getRepositorySignaturesPath(context);
        return ((NugetV3ProxyRepositorySignaturesFacet)this.facet(NugetV3ProxyRepositorySignaturesFacet.class)).rewriteRepositorySignaturesIndex(storedContent, repositorySignaturesPath);
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Context context, Content content, CacheInfo cacheInfo) {
        Objects.requireNonNull(cacheInfo);
        Asset asset = this.findAsset(OrientNugetAssetUtils.assetName(context));
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent nuget asset: {} on repository: {}", (Object)OrientNugetAssetUtils.assetName(context), (Object)this.getRepository().getName());
            return;
        }
        this.log.debug("Updating cacheInfo for asset: {} on repository: {} to {}", new Object[]{asset.name(), this.getRepository().getName(), cacheInfo});
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        this.storageTx().saveAsset(asset);
    }

    protected abstract Content getServiceIndexContent() throws IOException;

    protected abstract Content storeServiceIndex(Content var1) throws IOException;

    protected abstract Content rewriteRegistrationContent(AssetKind var1, String var2, Content var3) throws IOException;

    @Nullable
    private Asset findComponentAsset(Context context) {
        Component component = OrientNugetComponentHelper.findComponent(this.storageTx(), NugetContentMatcher.getContentPackageId(context), NugetContentMatcher.getContentVersion(context), Collections.singletonList(this.getRepository()));
        if (component == null) {
            return null;
        }
        return this.storageTx().firstAsset(component);
    }

    private Content storePackageContent(Context context, Content content) throws IOException {
        String packageId = NugetContentMatcher.getContentPackageId(context);
        String version = NugetContentMatcher.getContentVersion(context);
        String assetName = OrientNugetAssetUtils.assetName(context);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = ((StorageFacet)this.getRepository().facet(StorageFacet.class)).createTempBlob((Payload)content, NugetPackageUtils.HASH_ALGORITHMS);){
            return (Content)TransactionalStoreBlob.operation.throwing(IOException.class).withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).call(() -> {
                Component component = this.findOrCreatePackageComponent(packageId, version);
                Asset asset = this.findOrCreatePackageAsset(assetName, version, component);
                return OrientNugetAssetUtils.toContent(OrientNugetAssetUtils.updateAsset(this.storageTx(), assetName, asset, tempBlob, content), this.storageTx().requireBlob(asset.requireBlobRef()));
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Component findOrCreatePackageComponent(String packageId, String version) {
        Component component = OrientNugetComponentHelper.findComponent(this.storageTx(), packageId, version, Collections.singletonList(this.getRepository()));
        if (component == null) {
            component = OrientNugetComponentHelper.createComponent(this.storageTx(), this.getRepository(), packageId, version);
            component.formatAttributes().set("id", (Object)packageId);
            component.formatAttributes().set("version", (Object)version);
            this.storageTx().saveComponent(component);
        }
        return component;
    }

    public Asset findOrCreatePackageAsset(String name, String version, Component component) {
        Asset asset = OrientNugetAssetUtils.findAssetWithName(this.storageTx(), name, component);
        if (asset == null) {
            asset = OrientNugetAssetUtils.createAssetWithName(this.storageTx(), name, this.getRepository(), component);
            asset.formatAttributes().set("is_prerelease", (Object)this.isPrerelease(version));
            this.storageTx().saveAsset(asset);
        }
        return asset;
    }

    protected boolean isPrerelease(String version) {
        int prereleaseIdx = version.indexOf(45);
        int metadataIdx = version.indexOf(43);
        return prereleaseIdx > 0 && (metadataIdx == -1 || prereleaseIdx < metadataIdx);
    }

    @Nullable
    protected Asset findAsset(String name) {
        return OrientNugetAssetUtils.findAssetWithName(this.storageTx(), name, this.getRepository());
    }

    protected void deleteAsset(String assetName) {
        Asset asset = this.findAsset(assetName);
        if (asset != null) {
            this.storageTx().deleteAsset(asset);
        }
    }

    private StorageTx storageTx() {
        return (StorageTx)UnitOfWork.currentTx();
    }

    private boolean getReturnsOriginalContentParam(Context context) {
        Boolean obj = (Boolean)context.getAttributes().get("RETURNS_ORIGINAL_CONTENT", Boolean.class);
        return Boolean.TRUE.equals(obj);
    }
}

