/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.primitives.Ints;
import com.google.common.xml.XmlEscapers;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.internal.NugetDataUtils;
import com.sonatype.nexus.repository.nuget.internal.v2.NugetGalleryFacetSupport;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import com.sonatype.nexus.repository.nuget.odata.ODataTemplates;
import com.sonatype.nexus.repository.nuget.odata.ODataUtils;
import com.sonatype.nexus.repository.nuget.orient.OrientComponentContent;
import com.sonatype.nexus.repository.nuget.orient.OrientNugetComponentHelper;
import com.sonatype.nexus.repository.nuget.orient.OrientNugetPackageCoords;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientFeedResult;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetStateValidator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;
import org.odata4j.producer.InlineCount;
import org.odata4j.producer.resources.OptionsQueryParser;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobRef;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.HasFacet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.ComponentCreatedEvent;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;
import org.sonatype.nexus.repository.storage.ComponentEvent;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class OrientNugetLocalGalleryFacetSupport
extends NugetGalleryFacetSupport {
    protected static final TypeReference<List<String>> STRING_LIST = new TypeReference<List<String>>(){};
    @VisibleForTesting
    protected Clock clock = new Clock();
    private static final VersionScheme SCHEME = new GenericVersionScheme();
    private final OrientNugetAssetStateValidator assetStateValidator;
    private final boolean isLatestMultipleAllowed;
    @Nullable
    private CooperationFactory.Builder cooperationBuilder;
    @Nullable
    private Cooperation feedCooperation;

    @Inject
    protected OrientNugetLocalGalleryFacetSupport(OrientNugetAssetStateValidator assetStateValidator, @Named(value="${nexus.nuget.allow.multiple.latest:-true}") boolean isLatestMultipleAllowed) {
        this.assetStateValidator = assetStateValidator;
        this.isLatestMultipleAllowed = isLatestMultipleAllowed;
    }

    @Inject
    protected void configureCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.nuget.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.nuget.cooperation.majorTimeout:-0s}") Time majorTimeout, @Named(value="${nexus.nuget.cooperation.minorTimeout:-30s}") Time minorTimeout, @Named(value="${nexus.nuget.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        if (cooperationEnabled) {
            this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
        }
    }

    @VisibleForTesting
    void buildCooperation() {
        if (this.cooperationBuilder != null) {
            String repositoryName = this.getRepository().getName();
            this.feedCooperation = this.cooperationBuilder.build(String.valueOf(repositoryName) + ":nuget_feed");
            this.log.info("Enabled NuGet feed cooperation for {}", (Object)repositoryName);
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.buildCooperation();
    }

    @Override
    @Guarded(by={"STARTED"})
    public int count(String operation, Map<String, String> query) {
        this.log.debug("Count: {}", query);
        return this.count(operation, query, this.getRepositories());
    }

    @Transactional
    protected int count(String operation, Map<String, String> query, Iterable<Repository> repositories) {
        Integer top;
        int count;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        if (this.isLatestMultipleAllowed) {
            count = this.executeCount(query, tx, repositories);
        } else {
            Query componentQuery = ODataUtils.query(query, true);
            count = this.executeCount(componentQuery, tx, repositories);
        }
        Integer skip = OptionsQueryParser.parseSkip((String)query.get("$skip"));
        if (skip != null && skip >= 0) {
            count = Math.max(0, count - skip);
        }
        if ((top = OptionsQueryParser.parseTop((String)query.get("$top"))) != null && top >= 0) {
            count = Math.min(count, top);
        }
        return count;
    }

    @Override
    @Guarded(by={"STARTED"})
    public String feed(String base, String operation, Map<String, String> query) {
        if (this.feedCooperation == null) {
            return this.doFeed(base, operation, query);
        }
        String feedKey = String.valueOf(base) + ':' + operation + ':' + query;
        try {
            return (String)this.feedCooperation.cooperate(feedKey, __ -> this.doFeed(base, operation, query));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String doFeed(String base, String operation, Map<String, String> query) {
        this.log.debug("Select: {}", query);
        List<Repository> repositories = this.getRepositories();
        OrientFeedResult result = this.queryFeed(base, operation, query, repositories);
        return this.renderFeedResults(result);
    }

    @Transactional
    protected OrientFeedResult queryFeed(String base, String operation, Map<String, String> query, Iterable<Repository> repositories) {
        OrientFeedResult result = new OrientFeedResult(base, operation, query);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        if (this.inlineCountRequested(query)) {
            int inlineCount;
            if (this.isLatestMultipleAllowed) {
                inlineCount = this.executeCount(query, tx, repositories);
            } else {
                inlineCount = this.executeCount(ODataUtils.query(query, true), tx, repositories);
                result.postProcess();
            }
            result.setCount(inlineCount);
        }
        int n = 0;
        for (Asset asset : this.findAssetsForQuery(tx, query, repositories)) {
            ++n;
            NestedAttributesMap nugetAttributes = asset.formatAttributes();
            Map<String, Object> data = this.toData(nugetAttributes, this.extraTemplateVars(base, operation));
            if (this.isLatestMultipleAllowed) {
                result.addEntryAsLatest(data);
            } else {
                result.addEntry(data);
            }
            if (n != 40) continue;
            result.setSkipLinkEntry(data);
        }
        return result;
    }

    private Iterable<Asset> findAssetsForQuery(StorageTx tx, Map<String, String> query, Iterable<Repository> repositories) {
        Optional<List<String>> idsForSimplifiedQueries = ODataUtils.idsForSimplifiedQueries(query);
        if (idsForSimplifiedQueries.isPresent()) {
            this.log.debug("Using simplified queries for ids [{}]", idsForSimplifiedQueries);
            int pageSize = ODataUtils.pageSize(query);
            return idsForSimplifiedQueries.get().stream().flatMap(id -> StreamSupport.stream(tx.findComponentsByNameCaseInsensitive(id, repositories, " LIMIT " + pageSize).spliterator(), false)).flatMap(component -> StreamSupport.stream(tx.browseAssets(component).spliterator(), false)).limit(pageSize).collect(Collectors.toList());
        }
        Query sqlQuery = this.isLatestMultipleAllowed ? ODataUtils.query(query, this.groupByName(), false) : ODataUtils.query(query, false);
        this.log.debug("OData query [{}] converted to SQL [{}]", query, (Object)sqlQuery);
        return tx.findAssets(sqlQuery, this.getRepositories());
    }

    protected String renderFeedResults(OrientFeedResult result) {
        StringBuilder xml = new StringBuilder();
        xml.append(this.interpolateTemplate(ODataTemplates.NUGET_FEED, this.extraTemplateVars(result.getBase(), result.getOperation())));
        if (result.getCount() != null) {
            xml.append(this.interpolateTemplate(ODataTemplates.NUGET_INLINECOUNT, (Map<String, ?>)ImmutableMap.of((Object)"COUNT", (Object)String.valueOf(result.getCount()))));
        }
        List<Map<String, ?>> entries = this.isLatestMultipleAllowed ? result.getEntriesAsLatest() : result.getEntries();
        for (Map<String, ?> data : entries) {
            xml.append(this.interpolateTemplate(ODataTemplates.NUGET_ENTRY, data));
        }
        if (result.getSkipLinkEntry() != null) {
            String skipLink = this.odataLink(result.getBase(), result.getOperation(), ODataFeedUtils.skipLinkQueryString(result.getQuery()));
            xml.append("  <link rel=\"next\" href=\"").append(XmlEscapers.xmlAttributeEscaper().escape(skipLink)).append("\"/>\n");
        }
        return xml.append("</feed>").toString();
    }

    public String odataLink(String base, String operation, String queryString) {
        return String.format("%s/%s()?%s", base, operation, queryString);
    }

    @Override
    @Guarded(by={"STARTED"})
    public String packageVersions(String base, String id, Map<String, String> parameters) {
        return this.jsonString(this.packageVersions(base, id, parameters, this.getRepositories()));
    }

    @Transactional
    protected Set<String> packageVersions(String base, String id, Map<String, String> parameters, Iterable<Repository> repositories) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Iterable assets = tx.findAssets(ODataUtils.packageVersionsQuery(id, parameters), repositories);
        return StreamSupport.stream(assets.spliterator(), false).map(a -> (String)a.formatAttributes().get("version", String.class)).collect(Collectors.toCollection(TreeSet::new));
    }

    protected String jsonString(Set<String> set) {
        try {
            return mapper.writeValueAsString(set);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @TransactionalStoreMetadata
    public void putMetadata(Map<String, String> metadata) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = this.createOrUpdateComponent(tx, metadata);
        Asset asset = this.findOrCreateAsset(tx, component);
        this.updateAssetMetadata(asset, metadata, component.isNew());
        tx.saveAsset(asset);
    }

    @Override
    public Content storeItem(Context context, Content content) throws IOException {
        NugetPackageCoords coords = this.coords(context);
        return this.putContent(coords.getId(), coords.getVersion(), content);
    }

    @Override
    public Content putContent(String id, String version, Content content) {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, NugetPackageUtils.HASH_ALGORITHMS);){
            return this.doPutContent(id, version, tempBlob, content.getAttributes());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutContent(String id, String version, TempBlob tempBlob, AttributesMap contentAttributes) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = this.findComponent(tx, id, version);
        Preconditions.checkState((component != null && tx.browseAssets(component).iterator().hasNext() ? 1 : 0) != 0, (Object)"Component metadata does not exist yet");
        return this.createOrUpdateAssetAndContents(tx, component, tempBlob, null, contentAttributes);
    }

    @Override
    public String entry(String base, String id, String version) {
        Map<String, ?> entryData = this.queryEntry(base, id, version);
        return this.renderEntryResult(entryData);
    }

    @Nullable
    @Transactional
    protected Map<String, ?> queryEntry(String base, String id, String version) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = this.findComponent(tx, id, version);
        if (component == null) {
            return null;
        }
        Asset asset = tx.firstAsset(component);
        Preconditions.checkState((asset != null ? 1 : 0) != 0);
        ImmutableMap extra = ImmutableMap.of((Object)"BASEURI", (Object)base, (Object)"NAMESPACES", (Object)" xmlns:d=\"http://schemas.microsoft.com/ado/2007/08/dataservices\" xmlns:m=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\" xmlns=\"http://www.w3.org/2005/Atom\"");
        return this.toData(asset.formatAttributes(), (Map<String, String>)extra);
    }

    protected String renderEntryResult(@Nullable Map<String, ?> entryData) {
        if (entryData != null) {
            StringBuilder xml = new StringBuilder();
            xml.append(this.interpolateTemplate(ODataTemplates.NUGET_ENTRY, entryData));
            return xml.toString();
        }
        return null;
    }

    @VisibleForTesting
    String interpolateTemplate(String template, Map<String, ?> entryData) {
        return ODataTemplates.interpolate(template, entryData);
    }

    private Map<String, String> extraTemplateVars(String base, String operation) {
        return ImmutableMap.of((Object)"BASEURI", (Object)base, (Object)"ENDPOINT", (Object)operation, (Object)"LASTUPDATED", (Object)ODataFeedUtils.datetime(this.clock.millis()), (Object)"NAMESPACES", (Object)"");
    }

    @Override
    @Guarded(by={"STARTED"})
    public Content put(Map<String, String> metadata, TempBlob tempBlob) {
        Preconditions.checkNotNull(metadata);
        Preconditions.checkNotNull((Object)tempBlob);
        Map<String, String> recordMetadata = this.buildRecordMetadata(metadata);
        return this.createOrUpdatePackageAndContents(recordMetadata, tempBlob).getContent();
    }

    @Override
    @Guarded(by={"STARTED"})
    public Content putHardlink(Map<String, String> metadata, AssetBlob assetBlob) {
        Preconditions.checkNotNull(metadata);
        Preconditions.checkNotNull((Object)assetBlob);
        Map<String, String> recordMetadata = this.buildRecordMetadata(metadata);
        return this.createOrUpdatePackageAndContentsWithHardlink(recordMetadata, assetBlob).getContent();
    }

    private Map<String, String> buildRecordMetadata(Map<String, String> metadata) {
        HashMap<String, String> recordMetadata = new HashMap<String, String>(metadata);
        String creationTime = ODataFeedUtils.datetime(this.clock.millis());
        recordMetadata.put("CREATED", creationTime);
        recordMetadata.put("LASTUPDATED", creationTime);
        recordMetadata.put("PUBLISHED", creationTime);
        return recordMetadata;
    }

    @Override
    public Content getItem(Context context) throws IOException {
        NugetPackageCoords coords = this.coords(context);
        return this.get(coords.getId(), coords.getVersion());
    }

    @Override
    @Guarded(by={"STARTED"})
    @TransactionalTouchBlob
    public Content get(String id, String version) throws IOException {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)version);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.findAsset(tx, id, version);
        if (asset == null) {
            return null;
        }
        BlobRef blobRef = asset.blobRef();
        if (blobRef == null) {
            return null;
        }
        Blob blob = tx.requireBlob(blobRef);
        return this.toContent(asset, blob);
    }

    private Content toContent(Asset asset, Blob blob) {
        String contentType = asset.contentType();
        Content content = new Content((Payload)new BlobPayload(blob, contentType));
        Content.extractFromAsset((Asset)asset, NugetPackageUtils.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Override
    public void setCacheInfo(Context context, Content content, CacheInfo cacheInfo) {
        NugetPackageCoords coords = this.coords(context);
        this.setCacheInfo(coords.getId(), coords.getVersion(), content, cacheInfo);
    }

    @Override
    @TransactionalTouchMetadata
    public void setCacheInfo(String id, String version, Content content, CacheInfo cacheInfo) {
        Preconditions.checkNotNull((Object)cacheInfo);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            asset = this.findAsset(tx, id, version);
        }
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent nuget asset {} {}", (Object)id, (Object)version);
            return;
        }
        this.log.debug("Updating cacheInfo of {} {} to {}", new Object[]{id, version, cacheInfo});
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @Override
    @TransactionalDeleteBlob
    public boolean delete(String id, String version) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)version);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = this.findComponent(tx, id, version);
        if (component == null) {
            return false;
        }
        tx.deleteComponent(component);
        return true;
    }

    @TransactionalStoreBlob
    @VisibleForTesting
    protected OrientComponentContent createOrUpdatePackageAndContents(Map<String, String> recordMetadata, TempBlob tempBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = this.createOrUpdateComponent(tx, recordMetadata);
        Content content = this.createOrUpdateAssetAndContents(tx, component, tempBlob, recordMetadata, null);
        return new OrientComponentContent(component, content);
    }

    @TransactionalStoreBlob
    protected OrientComponentContent createOrUpdatePackageAndContentsWithHardlink(Map<String, String> recordMetadata, AssetBlob assetBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = this.createOrUpdateComponent(tx, recordMetadata);
        Content content = this.createOrUpdateAssetAndContentsWithHardlink(tx, component, assetBlob, recordMetadata, null);
        return new OrientComponentContent(component, content);
    }

    @VisibleForTesting
    void updateAssetMetadata(Asset asset, @Nullable Map<String, String> data, boolean componentIsNew) {
        if (data != null) {
            NestedAttributesMap nugetAttr = asset.formatAttributes();
            this.setDerivedAttributes(data, nugetAttr, !componentIsNew);
            nugetAttr.set("authors", (Object)data.get("AUTHORS"));
            nugetAttr.set("copyright", (Object)data.get("COPYRIGHT"));
            nugetAttr.set("dependencies", (Object)data.get("DEPENDENCIES"));
            nugetAttr.set("description", (Object)data.get("DESCRIPTION"));
            nugetAttr.set("gallery_details_url", (Object)data.get("GALLERYDETAILSURL"));
            nugetAttr.set("icon_url", (Object)data.get("ICONURL"));
            nugetAttr.set("id", (Object)data.get("ID"));
            nugetAttr.set("is_prerelease", (Object)NugetDataUtils.isPrerelease(data));
            nugetAttr.set("language", (Object)data.get("LANGUAGE"));
            nugetAttr.set("license", (Object)data.get("LICENSE"));
            nugetAttr.set("license_type", (Object)data.get("LICENSETYPE"));
            nugetAttr.set("license_url", (Object)data.get("LICENSEURL"));
            nugetAttr.set("location", (Object)data.get("LOCATION"));
            nugetAttr.set("package_hash", (Object)data.get("PACKAGEHASH"));
            nugetAttr.set("package_hash_algorithm", (Object)data.get("PACKAGEHASHALGORITHM"));
            nugetAttr.set("package_size", (Object)Long.parseLong(data.get("PACKAGESIZE")));
            nugetAttr.set("project_url", (Object)data.get("PROJECTURL"));
            nugetAttr.set("release_notes", (Object)data.get("RELEASENOTES"));
            nugetAttr.set("report_abuse_url", (Object)data.get("REPORTABUSEURL"));
            nugetAttr.set("require_license_acceptance", (Object)Boolean.parseBoolean(data.get("REQUIRELICENSEACCEPTANCE")));
            nugetAttr.set("summary", (Object)data.get("SUMMARY"));
            nugetAttr.set("tags", (Object)data.get("TAGS"));
            nugetAttr.set("title", (Object)data.get("TITLE"));
            nugetAttr.set("version", (Object)NugetDataUtils.normalizeVersion(data));
            nugetAttr.set("min_client_version", (Object)data.get("MINCLIENTVERSION"));
            OrientNugetComponentHelper.updateDerivedTextFields(asset);
        }
    }

    private Asset findOrCreateAsset(StorageTx tx, Component component) {
        Asset asset = tx.firstAsset(component);
        if (asset == null) {
            asset = tx.createAsset(this.getRepositoryBucket(tx), component);
            asset.name(OrientNugetPackageCoords.fromComponent(component).toString());
        }
        return asset;
    }

    @Nullable
    @VisibleForTesting
    protected Asset findAsset(StorageTx tx, String id, String version) {
        Component component = this.findComponent(tx, id, version);
        if (component == null) {
            return null;
        }
        return tx.firstAsset(component);
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void on(ComponentDeletedEvent deleted) {
        if (deleted.isLocal()) {
            this.maintainAggregateInfo((ComponentEvent)deleted);
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void on(ComponentCreatedEvent created) {
        if (created.isLocal()) {
            this.maintainAggregateInfo((ComponentEvent)created);
        }
    }

    private void maintainAggregateInfo(ComponentEvent event) {
        Repository repository = this.getRepository();
        if (!repository.getName().equals(event.getRepositoryName())) {
            return;
        }
        UnitOfWork.begin(this.storageTxSupplier());
        try {
            this.maintainAggregateInfo(event.getComponent().name());
        }
        finally {
            UnitOfWork.end();
        }
    }

    private Supplier<StorageTx> storageTxSupplier() {
        return ((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier();
    }

    @TransactionalStoreMetadata
    protected void maintainAggregateInfo(String id) {
        this.log.debug("Updating aggregate info for component {}", (Object)id);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        this.maintainAggregateInfo(tx, tx.findComponents(Query.builder().where("name").eq((Object)id).build(), this.getRepositories()));
    }

    @VisibleForTesting
    void maintainAggregateInfo(StorageTx tx, Iterable<Component> versions) {
        long totalDownloadCount = 0L;
        TreeSet releases = Sets.newTreeSet((Comparator)new ComponentVersionComparator());
        TreeSet allReleases = Sets.newTreeSet((Comparator)new ComponentVersionComparator());
        for (Component version : versions) {
            Asset asset = tx.firstAsset(version);
            if (asset == null) {
                this.log.error("Failed to find first asset for component: {}", (Object)version.toStringExternal());
                continue;
            }
            NestedAttributesMap nugetAttributes = asset.formatAttributes();
            boolean isPrerelease = (Boolean)nugetAttributes.require("is_prerelease", Boolean.class);
            if (!isPrerelease) {
                releases.add(version);
            }
            allReleases.add(version);
            Integer versionDownloadCount = (Integer)nugetAttributes.get("version_download_count", Integer.class);
            if (versionDownloadCount == null) continue;
            totalDownloadCount += (long)versionDownloadCount.intValue();
        }
        Component latestVersion = releases.isEmpty() ? null : (Component)releases.last();
        Component absoluteLatestVersion = allReleases.isEmpty() ? null : (Component)allReleases.last();
        for (Component component : allReleases) {
            Asset asset = tx.firstAsset(component);
            if (asset == null) {
                this.log.error("Failed to find first asset for component: {}", (Object)component.toStringExternal());
                continue;
            }
            NestedAttributesMap nugetAttributes = asset.formatAttributes();
            boolean latest = component.equals(latestVersion);
            boolean absoluteLatest = component.equals(absoluteLatestVersion);
            boolean needsUpdating = false;
            if (this.hasChanged("is_latest_version", nugetAttributes, latest)) {
                nugetAttributes.set("is_latest_version", (Object)latest);
                needsUpdating = true;
            }
            if (this.hasChanged("is_absolute_latest_version", nugetAttributes, absoluteLatest)) {
                nugetAttributes.set("is_absolute_latest_version", (Object)absoluteLatest);
                needsUpdating = true;
            }
            if (this.isRepoAuthoritative() && this.hasChanged("download_count", nugetAttributes, totalDownloadCount)) {
                nugetAttributes.set("download_count", (Object)totalDownloadCount);
                needsUpdating = true;
            }
            if (!needsUpdating) continue;
            tx.saveAsset(asset);
        }
    }

    private boolean hasChanged(String key, NestedAttributesMap nugetAttributes, long current) {
        Object value = nugetAttributes.get(key);
        return !(value instanceof Integer) || (long)((Integer)value).intValue() != current;
    }

    private boolean hasChanged(String key, NestedAttributesMap nugetAttributes, boolean current) {
        Object value = nugetAttributes.get(key);
        return !(value instanceof Boolean) || (Boolean)value != current;
    }

    private Content createOrUpdateAssetAndContents(StorageTx tx, Component component, TempBlob tempBlob, @Nullable Map<String, String> data, @Nullable AttributesMap contentAttributes) {
        try {
            Asset asset = this.findOrCreateAsset(tx, component);
            this.updateAssetMetadata(asset, data, component.isNew());
            boolean isNew = asset.isNew() || asset.blobRef() == null;
            Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
            AssetBlob assetBlob = tx.setBlob(asset, OrientNugetComponentHelper.blobName(component), tempBlob, null, "application/zip", true);
            tx.saveAsset(asset);
            Content content = this.toContent(asset, assetBlob.getBlob());
            this.assetStateValidator.setNew(content, isNew);
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Content createOrUpdateAssetAndContentsWithHardlink(StorageTx tx, Component component, AssetBlob assetBlob, @Nullable Map<String, String> data, @Nullable AttributesMap contentAttributes) {
        Asset asset = this.findOrCreateAsset(tx, component);
        this.updateAssetMetadata(asset, data, component.isNew());
        boolean isNew = asset.isNew() || asset.blobRef() == null;
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        tx.attachBlob(asset, assetBlob);
        tx.saveAsset(asset);
        Content content = this.toContent(asset, assetBlob.getBlob());
        this.assetStateValidator.setNew(content, isNew);
        return content;
    }

    @VisibleForTesting
    protected Component createOrUpdateComponent(StorageTx tx, Map<String, String> data) {
        String id = (String)Preconditions.checkNotNull((Object)data.get("ID"));
        String version = NugetDataUtils.checkVersion(NugetDataUtils.normalizeVersion(data));
        Component component = this.findOrCreateComponent(tx, id, version);
        NestedAttributesMap nugetAttr = component.formatAttributes();
        nugetAttr.set("id", (Object)data.get("ID"));
        nugetAttr.set("package_hash", (Object)data.get("PACKAGEHASH"));
        nugetAttr.set("package_hash_algorithm", (Object)data.get("PACKAGEHASHALGORITHM"));
        nugetAttr.set("title", (Object)data.get("TITLE"));
        nugetAttr.set("version", (Object)version);
        tx.saveComponent(component);
        return component;
    }

    @VisibleForTesting
    void setDerivedAttributes(Map<String, String> incomingMetadata, NestedAttributesMap storedMetadata, boolean republishing) {
        if (!republishing) {
            if (this.isRepoAuthoritative()) {
                storedMetadata.set("download_count", (Object)0);
                storedMetadata.set("version_download_count", (Object)0);
            } else {
                storedMetadata.set("download_count", (Object)this.parseIntOrZero(incomingMetadata.get("DOWNLOADCOUNT")));
                storedMetadata.set("version_download_count", (Object)this.parseIntOrZero(incomingMetadata.get("VERSIONDOWNLOADCOUNT")));
            }
        }
        Date now = new Date(this.clock.millis());
        if (!republishing && this.isRepoAuthoritative()) {
            storedMetadata.set("created", (Object)now);
            storedMetadata.set("published", (Object)now);
        } else {
            storedMetadata.set("created", (Object)ODataUtils.toDate(incomingMetadata.get("CREATED")));
            storedMetadata.set("published", (Object)ODataUtils.toDate(incomingMetadata.get("PUBLISHED")));
        }
        String lastUpdated = incomingMetadata.get("LASTUPDATED");
        storedMetadata.set("last_updated", (Object)(lastUpdated == null ? new Date() : ODataUtils.toDate(lastUpdated)));
    }

    private Component findOrCreateComponent(StorageTx tx, String name, String version) {
        Component found = this.findComponent(tx, name, version);
        if (found != null) {
            return found;
        }
        return this.createComponent(tx, name, version);
    }

    @VisibleForTesting
    Component findComponent(StorageTx tx, String name, String version) {
        return OrientNugetComponentHelper.findComponent(tx, name, version, this.getRepositories());
    }

    private Component createComponent(StorageTx tx, String name, String version) {
        this.log.debug("Creating NuGet component {} v. {}", (Object)name, (Object)version);
        return OrientNugetComponentHelper.createComponent(tx, this.getRepository(), name, version);
    }

    private Bucket getRepositoryBucket(StorageTx tx) {
        return (Bucket)Preconditions.checkNotNull((Object)tx.findBucket(this.getRepository()));
    }

    private boolean inlineCountRequested(Map<String, String> query) {
        return InlineCount.ALLPAGES.equals((Object)OptionsQueryParser.parseInlineCount((String)query.get("$inlinecount")));
    }

    @Deprecated
    private int executeCount(Query query, StorageTx tx, Iterable<Repository> repositories) {
        return Ints.checkedCast((long)tx.countAssets(query, repositories));
    }

    private int executeCount(Map<String, String> query, StorageTx tx, Iterable<Repository> repositories) {
        List<String> groupBy = this.groupByName();
        Query componentQuery = ODataUtils.query(query, groupBy, true);
        if (!groupBy.isEmpty()) {
            return Ints.checkedCast((long)tx.countGroupedAssets(componentQuery, repositories));
        }
        return Ints.checkedCast((long)tx.countAssets(componentQuery, repositories));
    }

    protected Iterable<Repository> getHostedRepositories() {
        return Iterables.filter(this.getRepositories(), (Predicate)Predicates.not((Predicate)new HasFacet(ProxyFacet.class)));
    }

    protected Iterable<Repository> getProxyRepositories() {
        return Iterables.filter(this.getRepositories(), (Predicate)new HasFacet(ProxyFacet.class));
    }

    @VisibleForTesting
    static class ComponentVersionComparator
    implements Comparator<Component> {
        ComponentVersionComparator() {
        }

        @Override
        public int compare(Component o1, Component o2) {
            try {
                Version v1 = SCHEME.parseVersion(o1.requireVersion());
                Version v2 = SCHEME.parseVersion(o2.requireVersion());
                return v1.compareTo((Object)v2);
            }
            catch (InvalidVersionSpecificationException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

