/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.restore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetRestoreBlobType;
import com.sonatype.nexus.repository.nuget.internal.NugetDataUtils;
import com.sonatype.nexus.repository.nuget.orient.OrientNugetRestoreFacet;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetUtils;
import com.sonatype.nexus.repository.nuget.orient.internal.v3.OrientNugetV3ProxyFacetImpl;
import com.sonatype.nexus.repository.nuget.v2.NugetGalleryFacet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientNugetRestoreFacetImpl
extends FacetSupport
implements OrientNugetRestoreFacet {
    private NugetGalleryFacet orientNugetGalleryFacet;
    private Optional<OrientNugetV3ProxyFacetImpl> nugetV3ProxyFacetImplOpt;

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.orientNugetGalleryFacet = (NugetGalleryFacet)this.getRepository().facet(NugetGalleryFacet.class);
        this.nugetV3ProxyFacetImplOpt = this.getRepository().optionalFacet(OrientNugetV3ProxyFacetImpl.class);
    }

    @Override
    @TransactionalTouchBlob
    public void restore(AssetBlob assetBlob, String assetPath, Map<String, String> metadata, NugetRestoreBlobType nugetBlobType) {
        Asset asset;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        switch (nugetBlobType) {
            case V2_BLOB_PACKAGE: {
                asset = this.restoreV2Blob(assetPath, metadata, tx);
                break;
            }
            case V3_BLOB_PACKAGE: {
                asset = this.restoreV3Blob(assetPath, metadata);
                break;
            }
            case V3_BLOB_METADATA: {
                asset = OrientNugetAssetUtils.findOrCreateAssetWithName(tx, assetPath, this.getRepository());
                break;
            }
            default: {
                throw new IllegalArgumentException(nugetBlobType.toString());
            }
        }
        tx.attachBlob(asset, assetBlob);
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, null));
        tx.saveAsset(asset);
    }

    private Asset restoreV2Blob(String path, Map<String, String> metadata, StorageTx tx) {
        NugetPackageCoords nugetCoordV2 = this.getPackageIdAndVersionFromPath(path, metadata);
        this.orientNugetGalleryFacet.putMetadata(metadata);
        return OrientNugetAssetUtils.findAssetWithName(tx, nugetCoordV2.toString(), this.getRepository());
    }

    private Asset restoreV3Blob(String path, Map<String, String> metadata) {
        NugetPackageCoords nugetCoordV3 = this.getPackageIdAndVersionFromPath(path, metadata);
        OrientNugetV3ProxyFacetImpl nugetV3ProxyFacet = this.nugetV3ProxyFacetImplOpt.orElseThrow(() -> new IllegalStateException("Restore V3 cannot be done without NugetV3ProxyFacet in repository"));
        Component component = nugetV3ProxyFacet.findOrCreatePackageComponent(nugetCoordV3.getId(), nugetCoordV3.getVersion());
        return nugetV3ProxyFacet.findOrCreatePackageAsset(nugetCoordV3.toString(), nugetCoordV3.getVersion(), component);
    }

    @Override
    public NugetPackageCoords getPackageIdAndVersionFromPath(String path, Map<String, String> metadata) {
        String version;
        String id;
        Map parsedPath = new TokenParser("{id}/{version}").parse(path);
        if (parsedPath != null) {
            id = (String)parsedPath.get("id");
            version = (String)parsedPath.get("version");
        } else {
            id = (String)Preconditions.checkNotNull((Object)metadata.get("ID"));
            version = NugetDataUtils.checkVersion(NugetDataUtils.normalizeVersion(metadata));
        }
        return new NugetPackageCoords(id, version);
    }

    @Override
    @TransactionalTouchBlob
    public boolean assetExists(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository())) != null;
    }

    @Override
    public Query getComponentQuery(NugetPackageCoords nugetPackageCoords) {
        return Query.builder().where("ci_name").eq((Object)nugetPackageCoords.getId().toLowerCase(Locale.ENGLISH)).and("version").eq((Object)nugetPackageCoords.getVersion()).build();
    }
}

