/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.nuget.NugetVersion;
import com.sonatype.nexus.repository.nuget.internal.NugetProxy;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.orient.internal.v2.OrientNugetCachingGalleryFacet;
import com.sonatype.nexus.repository.nuget.orient.internal.v2.OrientNugetProxyGalleryFacetImpl;
import com.sonatype.nexus.repository.nuget.orient.internal.v3.OrientNugetV3ProxyFacetImpl;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.RepositoryEvent;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;

@Facet.Exposed
public class OrientNugetProxyFacet
extends ProxyFacetSupport {
    public void invalidateProxyCaches() {
        super.invalidateProxyCaches();
        this.optionalFacet(OrientNugetCachingGalleryFacet.class).ifPresent(OrientNugetCachingGalleryFacet::invalidateCaches);
    }

    protected URI normalizeURLPath(URI remoteURI) {
        String nugetVersionAttribute = (String)this.getRepository().getConfiguration().attributes("nugetProxy").get("nugetVersion", String.class);
        if (NugetVersion.V3.name().equals(nugetVersionAttribute)) {
            return remoteURI;
        }
        return super.normalizeURLPath(remoteURI);
    }

    public Content getCachedContent(Context context) throws IOException {
        return this.nugetFacet(context).getItem(context);
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }

    protected Content store(Context context, Content payload) throws IOException {
        return this.nugetFacet(context).storeItem(context, payload);
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.nugetFacet(context).setCacheInfo(context, content, cacheInfo);
    }

    protected String getUrl(@Nonnull Context context) {
        return this.nugetFacet(context).getUrl(context);
    }

    @Nullable
    protected Content fetch(Context context, @Nullable Content stale) throws IOException {
        return this.nugetFacet(context).fetch(context, stale);
    }

    public Content fetch(String url, Context context, @Nullable Content stale) throws IOException {
        return url != null ? super.fetch(url, context, stale) : null;
    }

    private NugetProxy nugetFacet(Context context) {
        return ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))).version() == NugetVersion.V2 ? (NugetProxy)this.facet(OrientNugetProxyGalleryFacetImpl.class) : (NugetProxy)this.facet(OrientNugetV3ProxyFacetImpl.class);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryEvent event) {
        if (this.shouldRemoveServiceIndex(event)) {
            this.optionalFacet(NugetV3ServiceIndexFacet.class).ifPresent(NugetV3ServiceIndexFacet::removeServiceIndex);
        }
    }

    private boolean shouldRemoveServiceIndex(RepositoryEvent event) {
        if (event.getRepository().getType() instanceof ProxyType && event instanceof RepositoryUpdatedEvent) {
            String currentUrl;
            Map oldConfiguration = Objects.requireNonNull(((RepositoryUpdatedEvent)event).getOldConfiguration().getAttributes());
            String previousUrl = NugetV3ProxyUtil.trimSlashes(((Map)oldConfiguration.get("proxy")).get("remoteUrl").toString());
            return !previousUrl.equals(currentUrl = NugetV3ProxyUtil.trimSlashes(this.getRemoteUrl().toString()));
        }
        return false;
    }
}

