/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetContentMatcher;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

public class OrientNugetAssetUtils {
    private OrientNugetAssetUtils() {
    }

    public static Content storeContent(Repository repository, Content content, String contentName) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = ((StorageFacet)repository.facet(StorageFacet.class)).createTempBlob((Payload)content, NugetPackageUtils.HASH_ALGORITHMS);){
            return (Content)TransactionalStoreBlob.operation.throwing(IOException.class).withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Asset asset = OrientNugetAssetUtils.findOrCreateAssetWithName(tx, contentName, repository);
                OrientNugetAssetUtils.updateAsset(tx, contentName, asset, tempBlob, content);
                return OrientNugetAssetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void storePayload(Repository repository, Payload payload, String contentName) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob tempBlob = ((StorageFacet)repository.facet(StorageFacet.class)).createTempBlob(payload, NugetPackageUtils.HASH_ALGORITHMS);){
            TransactionalStoreBlob.operation.throwing(IOException.class).withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).call(() -> {
                StorageTx tx = (StorageTx)UnitOfWork.currentTx();
                Asset asset = OrientNugetAssetUtils.findOrCreateAssetWithName(tx, contentName, repository);
                tx.setBlob(asset, contentName, tempBlob, null, payload.getContentType(), true);
                tx.saveAsset(asset);
                return null;
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Asset updateAsset(StorageTx tx, String name, Asset asset, TempBlob tempBlob, Content content) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes()));
        tx.setBlob(asset, name, tempBlob, null, content.getContentType(), true);
        tx.saveAsset(asset);
        return asset;
    }

    public static Asset findOrCreateAssetWithName(StorageTx tx, String name, Repository repository) {
        Asset asset = OrientNugetAssetUtils.findAssetWithName(tx, name, repository);
        return asset != null ? asset : OrientNugetAssetUtils.createAssetWithName(tx, name, repository, null);
    }

    public static Asset findAssetWithName(StorageTx tx, String name, Repository repository) {
        return tx.findAssetWithProperty("name", (Object)name, tx.findBucket(repository));
    }

    public static Asset findAssetWithName(StorageTx tx, String name, Component component) {
        return tx.findAssetWithProperty("name", (Object)name, component);
    }

    public static Asset createAssetWithName(StorageTx tx, String name, Repository repository, @Nullable Component component) {
        return component == null ? (Asset)tx.createAsset(tx.findBucket(repository), repository.getFormat()).name(name) : (Asset)tx.createAsset(tx.findBucket(repository), component).name(name);
    }

    public static Content toContent(Asset asset, Blob blob) {
        return OrientNugetAssetUtils.toContent(asset, (Payload)new BlobPayload(blob, asset.contentType()));
    }

    public static Content toContent(Asset asset, Payload payload) {
        Content content = new Content(payload);
        Content.extractFromAsset((Asset)asset, NugetPackageUtils.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    public static <T> T readContent(ObjectMapper objectMapper, InputStreamSupplier inputStream, Class<T> type) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = inputStream.get();){
            return (T)objectMapper.readValue(in, type);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String assetName(Context context) {
        switch ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))) {
            case SERVICE_INDEX: {
                return "index.json";
            }
            case CONTENT: {
                return NugetV3ProxyUtil.joinPath(NugetContentMatcher.getContentPackageId(context), NugetContentMatcher.getContentVersion(context));
            }
        }
        return NugetV3ProxyUtil.trimSlashes(context.getRequest().getPath());
    }
}

