/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sonatype.nexus.common.app.VersionComparator;

public class OrientFeedResult {
    private final String base;
    private final String operation;
    private final Map<String, String> query;
    private Integer count;
    private Map<String, ?> skipLinkEntry;
    private List<Map<String, ?>> entries = new ArrayList();
    private Map<String, FeedEntry> oldEntries = new LinkedHashMap<String, FeedEntry>();

    public OrientFeedResult(String base, String operation, Map<String, String> query) {
        this.base = base;
        this.operation = operation;
        this.query = query;
    }

    public void addEntry(Map<String, ?> entry) {
        this.checkEntriesAndMaybeAdd(entry);
    }

    public void addEntryAsLatest(Map<String, ?> entry) {
        this.entries.add(entry);
    }

    private void checkEntriesAndMaybeAdd(Map<String, ?> entry) {
        String id = (String)entry.get("id");
        FeedEntry feedEntry = this.oldEntries.containsKey(id) ? this.oldEntries.get(id) : new FeedEntry();
        feedEntry.add(entry);
        this.oldEntries.put(id, feedEntry);
    }

    public void postProcess() {
        this.oldEntries.forEach((id, entry) -> ((FeedEntry)entry).setVersionFlags());
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getBase() {
        return this.base;
    }

    public String getOperation() {
        return this.operation;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public Integer getCount() {
        return this.count;
    }

    public List<Map<String, ?>> getEntriesAsLatest() {
        return this.entries;
    }

    public List<Map<String, ?>> getEntries() {
        ArrayList entryList = new ArrayList();
        this.oldEntries.forEach((id, entry) -> ((FeedEntry)entry).entries().forEach((k, v) -> {
            boolean bl = entryList.add((Map)v);
        }));
        return entryList;
    }

    public Map<String, ?> getSkipLinkEntry() {
        return this.skipLinkEntry;
    }

    public void setSkipLinkEntry(Map<String, ?> skipLinkEntry) {
        this.skipLinkEntry = skipLinkEntry;
    }

    private static class FeedEntry {
        private static final VersionComparator VERSION_COMPARATOR = new VersionComparator();
        private TreeMap<String, Map<String, ?>> versionEntries = Maps.newTreeMap((Comparator)new VersionComparator());
        private String latestReleaseVersion;
        private String absoluteLatestVersion;

        private FeedEntry() {
        }

        private void add(Map<String, ?> entry) {
            String version = entry.get("version").toString();
            if (!this.versionEntries.containsKey(version)) {
                this.versionEntries.put(version, entry);
                this.clearVersionFlags(entry);
                this.maybeUpdateVersions(entry);
            }
        }

        private void clearVersionFlags(Map entry) {
            entry.put("is_latest_version", Boolean.FALSE);
            entry.put("is_absolute_latest_version", Boolean.FALSE);
        }

        private void maybeUpdateVersions(Map<String, ?> entry) {
            this.maybeUpdateAbsoluteLatestVersion();
            this.maybeUpdateLatestVersion(entry);
        }

        private void maybeUpdateLatestVersion(Map<String, ?> entry) {
            boolean isPreRelease;
            String version = (String)entry.get("version");
            boolean bl = isPreRelease = entry.get("is_prerelease") != null && (Boolean)entry.get("is_prerelease") != false;
            if (!isPreRelease && (Strings.isNullOrEmpty((String)this.latestReleaseVersion) || VERSION_COMPARATOR.compare(version, this.latestReleaseVersion) > 0)) {
                this.latestReleaseVersion = version;
            }
        }

        private void maybeUpdateAbsoluteLatestVersion() {
            this.absoluteLatestVersion = (String)this.versionEntries.lastEntry().getValue().get("version");
        }

        private Map<String, ?> entries() {
            return this.versionEntries;
        }

        private void setVersionFlags() {
            if (!Strings.isNullOrEmpty((String)this.absoluteLatestVersion)) {
                Map<String, ?> entry = this.versionEntries.get(this.absoluteLatestVersion);
                entry.put("is_absolute_latest_version", Boolean.TRUE);
                if (!Strings.isNullOrEmpty((String)this.latestReleaseVersion)) {
                    entry = this.versionEntries.get(this.latestReleaseVersion);
                }
                entry.put("is_latest_version", Boolean.TRUE);
            }
        }
    }
}

