/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.internal.NugetUploadHandlerSupport;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.v2.NugetGalleryFacet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.hash.HashAlgorithmHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.OrientHardLinkHelper;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="nuget")
@Singleton
public class OrientNugetUploadHandler
extends NugetUploadHandlerSupport {
    private final OrientHardLinkHelper hardLinkHelper;
    private final HashAlgorithmHelper hashAlgorithmHelper;

    @Inject
    public OrientNugetUploadHandler(ContentPermissionChecker contentPermissionCheckerr, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions, OrientHardLinkHelper hardLinkHelper, HashAlgorithmHelper hashAlgorithmHelper) {
        super(contentPermissionCheckerr, variableResolverAdapter, uploadDefinitionExtensions);
        this.hardLinkHelper = (OrientHardLinkHelper)Preconditions.checkNotNull((Object)hardLinkHelper);
        this.hashAlgorithmHelper = (HashAlgorithmHelper)Preconditions.checkNotNull((Object)hashAlgorithmHelper);
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)upload);
        return this.doUpload(repository, upload);
    }

    public Content handle(Repository repository, File file, String path) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)path);
        return this.handle(new ImportFileConfiguration(repository, file, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        Preconditions.checkNotNull((Object)configuration);
        if (NugetPackageUtils.isV3Metadata(configuration.getFile().getName())) {
            this.log.trace("Skipping {} as we only care about NuGet packages.", (Object)configuration.getFile().getName());
            return null;
        }
        if (configuration.isHardLinkingEnabled()) {
            return this.handleHardLinkImport(configuration);
        }
        return this.handleImport(configuration);
    }

    private Content handleHardLinkImport(ImportFileConfiguration configuration) throws IOException {
        Map<String, String> metadata;
        Preconditions.checkNotNull((Object)configuration);
        Repository repository = configuration.getRepository();
        NugetGalleryFacet galleryFacet = (NugetGalleryFacet)repository.facet(NugetGalleryFacet.class);
        File file = configuration.getFile();
        Map checksums = this.hashAlgorithmHelper.calculateChecksums(file, NugetPackageUtils.HASH_ALGORITHMS);
        AssetBlob assetBlob = this.hardLinkHelper.ingestHardLink((StorageTx)UnitOfWork.currentTx(), file, checksums);
        try {
            metadata = this.getMetadata(assetBlob.getBlob());
        }
        catch (NugetPackageException e) {
            throw new IOException("Unable to get valid component from supplied file", e);
        }
        NugetPackageCoords nugetPackageCoords = new NugetPackageCoords(metadata.get("ID"), metadata.get("VERSION"));
        String securityPath = String.valueOf(nugetPackageCoords.getId()) + "/" + nugetPackageCoords.getVersion();
        this.ensurePermitted(repository.getName(), "nuget", securityPath, this.toMap(nugetPackageCoords));
        Content content = galleryFacet.putHardlink(metadata, assetBlob);
        this.log.debug("Added NuGet component {}", (Object)nugetPackageCoords);
        return content;
    }

    private Content handleImport(ImportFileConfiguration configuration) throws IOException {
        Repository repository = configuration.getRepository();
        NugetGalleryFacet galleryFacet = (NugetGalleryFacet)repository.facet(NugetGalleryFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        File file = configuration.getFile();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TempBlob tempBlob = storageFacet.createTempBlob(Files.newInputStream(file.toPath(), new OpenOption[0]), NugetPackageUtils.HASH_ALGORITHMS);){
                Map<String, String> metadata = this.getMetadata(tempBlob);
                NugetPackageCoords nugetPackageCoords = new NugetPackageCoords(metadata.get("ID"), metadata.get("VERSION"));
                String securityPath = String.valueOf(nugetPackageCoords.getId()) + "/" + nugetPackageCoords.getVersion();
                this.ensurePermitted(repository.getName(), "nuget", securityPath, this.toMap(nugetPackageCoords));
                Content content = galleryFacet.put(metadata, tempBlob);
                this.log.debug("Added NuGet component {}", (Object)nugetPackageCoords);
                return content;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NugetPackageException e) {
            throw new IllegalStateException("Unable to get valid component from supplied file", e);
        }
    }

    private UploadResponse doUpload(Repository repository, ComponentUpload component) throws IOException {
        NugetGalleryFacet galleryFacet = (NugetGalleryFacet)repository.facet(NugetGalleryFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        PartPayload payload = ((AssetUpload)component.getAssetUploads().get(0)).getPayload();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)payload, NugetPackageUtils.HASH_ALGORITHMS);){
                Content resultantContent;
                Map<String, String> metadata = this.getMetadata(tempBlob);
                NugetPackageCoords nugetPackageCoords = new NugetPackageCoords(metadata.get("ID"), metadata.get("VERSION"));
                String path = String.valueOf(nugetPackageCoords.getId()) + "/" + nugetPackageCoords.getVersion();
                this.ensurePermitted(repository.getName(), "nuget", path, this.toMap(nugetPackageCoords));
                UnitOfWork.begin((Supplier)storageFacet.txSupplier());
                try {
                    resultantContent = galleryFacet.put(metadata, tempBlob);
                }
                finally {
                    UnitOfWork.end();
                }
                this.log.debug("Added nuget component {}", (Object)nugetPackageCoords);
                return new UploadResponse(resultantContent, Collections.singletonList(nugetPackageCoords.toString()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NugetPackageException e) {
            throw new IOException("Unable to get valid component from supplied file", e);
        }
    }

    public boolean supportsExportImport() {
        return true;
    }
}

