/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient;

import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.internal.NugetReplicationHelper;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.OrientReplicationFacetSupport;
import org.sonatype.nexus.repository.storage.OrientReplicationIngestionService;

@Named
public class OrientNugetReplicationFacet
extends OrientReplicationFacetSupport {
    private final OrientReplicationIngestionService ingestionService;
    private final NugetReplicationHelper nugetReplicationHelper;

    @Inject
    public OrientNugetReplicationFacet(OrientReplicationIngestionService ingestionService, NugetReplicationHelper nugetReplicationHelper) {
        this.ingestionService = Objects.requireNonNull(ingestionService);
        this.nugetReplicationHelper = Objects.requireNonNull(nugetReplicationHelper);
    }

    public void doReplicate(String path, AssetBlob assetBlob, NestedAttributesMap assetAttributes, NestedAttributesMap componentAttributes) {
        if (NugetPackageUtils.isV3Metadata(path)) {
            this.ingestionService.replicateAsset(this.getRepository(), path, assetAttributes, assetBlob);
        } else {
            NugetPackageCoords coords = this.nugetReplicationHelper.getMetadata(assetBlob.getBlob());
            String name = coords.getId();
            String version = coords.getVersion();
            Component component = this.ingestionService.replicateComponent(this.getRepository(), name, version, null, componentAttributes);
            this.ingestionService.replicateAsset(this.getRepository(), coords.toString(), assetAttributes, assetBlob, component);
        }
    }

    public boolean doReplicateDelete(String path) {
        return this.ingestionService.replicateDeleteAsset(this.getRepository(), path);
    }
}

