/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.codehaus.plexus.util.StringUtils;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.odata4j.expression.BoolCommonExpression;
import org.odata4j.expression.BoolParenExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.OrExpression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.expression.ParenExpression;
import org.odata4j.expression.StringLiteral;
import org.odata4j.expression.ToLowerMethodCallExpression;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.jpa.JPASkipToken;
import org.odata4j.producer.jpa.JPQLGenerator;
import org.odata4j.producer.resources.OptionsQueryParser;
import org.sonatype.nexus.repository.storage.Query;

public final class ODataUtils {
    public static final ImmutableMap<String, String> COLUMN_ALIASES = ODataUtils.columnAliases();
    public static final int PAGE_SIZE = 40;
    public static final String TOP_PARAM = "$top";
    public static final String SKIP_PARAM = "$skip";
    public static final String FILTER_PARAM = "$filter";
    public static final String ORDERBY_PARAM = "$orderby";
    public static final String SKIPTOKEN_PARAM = "$skiptoken";
    public static final String SEARCH_TERM_PARAM = "searchTerm";
    public static final String TARGET_FRAMEWORK_PARAM = "targetFramework";
    public static final String INCLUDE_PRERELEASE_PARAM = "includePrerelease";
    private static final DateTimeFormatter ISO_PARSER = ISODateTimeFormat.dateTimeParser().withLocale(Locale.ENGLISH).withZoneUTC();

    public static long datetime(String millis) {
        return ISO_PARSER.parseMillis(millis);
    }

    public static Date toDate(String isoFormatDate) {
        return new Date(ODataUtils.datetime(isoFormatDate));
    }

    private ODataUtils() {
    }

    public static Query query(Map<String, String> originalQuery, boolean count) {
        return ODataUtils.query(originalQuery, Collections.emptyList(), count);
    }

    public static Query query(Map<String, String> originalQuery, List<String> groupBy, boolean count) {
        Map<String, String> query = ODataUtils.applyQueryDefaults(originalQuery);
        Query.Builder q = Query.builder();
        boolean hasTerms = false;
        String[] stringArray = ODataUtils.getSanitizedValue(query, SEARCH_TERM_PARAM).split("[+\\s]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            if (StringUtils.isNotBlank((String)term)) {
                term = String.valueOf('%') + term + '%';
                if (!hasTerms) {
                    q.where("(");
                    hasTerms = true;
                } else {
                    q.where(" OR ");
                }
                q.where(String.valueOf(ODataUtils.nugat("keywords")) + " LIKE ").param((Object)term.toLowerCase());
            }
            ++n2;
        }
        if (hasTerms) {
            q.where(")");
        }
        String id = StringUtils.strip((String)query.get("id"), (String)"\" '");
        ODataUtils.byPackageId(q, id);
        ODataUtils.includePrerelease(q, query);
        QueryInfo odata = ODataUtils.parseQuery(query);
        NugetJPQLGenerator generator = new NugetJPQLGenerator(null, null, (Map<String, String>)COLUMN_ALIASES);
        if (odata.filter != null) {
            if (q.hasWhere()) {
                q.where(" AND ");
            }
            q.where("(").where(generator.toJpql(odata.filter)).where(")");
        }
        if (odata.skipToken != null) {
            if (q.hasWhere()) {
                q.where(" AND ");
            }
            q.where(" (").where(generator.toJpql(JPASkipToken.parse(null, (List)odata.orderBy, (String)odata.skipToken, (String[])new String[]{"id", "version"}))).where(")");
        }
        if (!groupBy.isEmpty()) {
            q.suffix(" GROUP BY ");
            q.suffix(String.join((CharSequence)", ", groupBy));
        }
        if (!count) {
            q.suffix(" ORDER BY ");
            if (odata.orderBy != null) {
                int i = 0;
                int size = odata.orderBy.size();
                while (i < size) {
                    OrderByExpression o = (OrderByExpression)odata.orderBy.get(i);
                    q.suffix(generator.toJpql(o.getExpression()));
                    if (o.getDirection() == OrderByExpression.Direction.ASCENDING) {
                        q.suffix(" ASC");
                    } else if (o.getDirection() == OrderByExpression.Direction.DESCENDING) {
                        q.suffix(" DESC");
                    }
                    q.suffix(", ");
                    ++i;
                }
            }
            q.suffix(String.valueOf((String)COLUMN_ALIASES.get((Object)"ID")) + " ASC, ");
            q.suffix(String.valueOf((String)COLUMN_ALIASES.get((Object)"VERSION")) + " ASC");
            q.suffix(" LIMIT " + ODataUtils.pageSize(odata));
            if (odata.skip != null) {
                q.suffix(" OFFSET " + odata.skip);
            }
        }
        return q.build();
    }

    public static int pageSize(Map<String, String> query) {
        return ODataUtils.pageSize(ODataUtils.parseQuery(query));
    }

    private static int pageSize(QueryInfo odata) {
        int pageSize = 40;
        if (odata.top != null && odata.top < pageSize) {
            pageSize = odata.top;
        }
        return pageSize;
    }

    private static QueryInfo parseQuery(Map<String, String> query) {
        try {
            return new QueryInfo(null, OptionsQueryParser.parseTop((String)query.get(TOP_PARAM)), OptionsQueryParser.parseSkip((String)query.get(SKIP_PARAM)), OptionsQueryParser.parseFilter((String)query.get(FILTER_PARAM)), OptionsQueryParser.parseOrderBy((String)query.get(ORDERBY_PARAM)), OptionsQueryParser.parseSkipToken((String)query.get(SKIPTOKEN_PARAM)), null, null, null);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Bad Request - Error in query syntax.", e);
        }
    }

    private static void includePrerelease(Query.Builder q, Map<String, String> query) {
        if ("false".equalsIgnoreCase(ODataUtils.getSanitizedValue(query, INCLUDE_PRERELEASE_PARAM))) {
            if (q.hasWhere()) {
                q.where(" AND ");
            }
            q.where(" " + ODataUtils.jsonAttrib("ISPRERELEASE") + "=false ");
        }
    }

    private static void byPackageId(Query.Builder q, String id) {
        if (id != null) {
            if (q.hasWhere()) {
                q.where(" AND ");
            }
            q.where(String.valueOf(ODataUtils.jsonAttrib("ID")) + " = ").param((Object)id.toLowerCase(Locale.ENGLISH));
        }
    }

    public static Query packageVersionsQuery(String packageId, Map<String, String> originalQuery) {
        CaseInsensitiveMap query = new CaseInsensitiveMap(originalQuery);
        Query.Builder q = Query.builder();
        ODataUtils.byPackageId(q, packageId);
        ODataUtils.includePrerelease(q, (Map<String, String>)query);
        return q.build();
    }

    @Nonnull
    private static Map<String, String> applyQueryDefaults(Map<String, String> originalQuery) {
        CaseInsensitiveMap query = new CaseInsensitiveMap(originalQuery);
        if (!query.containsKey(ORDERBY_PARAM)) {
            query.put(ORDERBY_PARAM, "DOWNLOADCOUNT desc");
        } else {
            String orderby = (String)query.get(ORDERBY_PARAM);
            query.put(ORDERBY_PARAM, orderby.replaceAll("(?i)concat\\(title,id\\)", "NAME_ORDER"));
        }
        if (query.containsKey(FILTER_PARAM)) {
            String filter = (String)query.get(FILTER_PARAM);
            query.put(FILTER_PARAM, ODataUtils.applyQueryDefaultsToFilterParam(filter));
        }
        return query;
    }

    static String applyQueryDefaultsToFilterParam(String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            return filter;
        }
        return filter.replaceAll("(?i)IsLatestVersion eq True", "IsLatestVersion").replaceAll("(?i)IsAbsoluteLatestVersion eq True", "IsAbsoluteLatestVersion").replaceAll("(?i)(IsLatestVersion|IsAbsoluteLatestVersion)", "($1 eq true)");
    }

    private static ImmutableMap<String, String> columnAliases() {
        HashMap aliases = Maps.newHashMap();
        aliases.put("CREATED", ODataUtils.nugat("created"));
        aliases.put("DOWNLOADCOUNT", ODataUtils.nugat("download_count"));
        aliases.put("ID", "component.ci_name");
        aliases.put("ISABSOLUTELATESTVERSION", ODataUtils.nugat("is_absolute_latest_version"));
        aliases.put("ISLATESTVERSION", ODataUtils.nugat("is_latest_version"));
        aliases.put("ISPRERELEASE", ODataUtils.nugat("is_prerelease"));
        aliases.put("LASTUPDATED", ODataUtils.nugat("last_updated"));
        aliases.put("NAME_ORDER", ODataUtils.nugat("name_order"));
        aliases.put("PACKAGEHASH", ODataUtils.nugat("package_hash"));
        aliases.put("PACKAGEHASHALGORITHM", ODataUtils.nugat("package_hash_algorithm"));
        aliases.put("PACKAGESIZE", ODataUtils.nugat("package_size"));
        aliases.put("PUBLISHED", ODataUtils.nugat("published"));
        aliases.put("REQUIRELICENSEACCEPTANCE", ODataUtils.nugat("require_license_acceptance"));
        aliases.put("SUMMARY", ODataUtils.nugat("summary"));
        aliases.put("TITLE", ODataUtils.nugat("title"));
        aliases.put("VERSION", "component.version");
        aliases.put("VERSIONDOWNLOADCOUNT", ODataUtils.nugat("version_download_count"));
        return ImmutableMap.copyOf((Map)aliases);
    }

    private static String jsonAttrib(String elementName) {
        return (String)COLUMN_ALIASES.get((Object)elementName);
    }

    private static String nugat(String column) {
        return "attributes.nuget." + column;
    }

    public static Optional<List<String>> idsForSimplifiedQueries(Map<String, String> query) {
        if (query.get(SEARCH_TERM_PARAM) != null || query.get("id") != null || query.get(INCLUDE_PRERELEASE_PARAM) != null) {
            return Optional.empty();
        }
        QueryInfo odata = ODataUtils.parseQuery(query);
        return ODataUtils.idsForSimplifiedQuery((CommonExpression)odata.filter);
    }

    private static Optional<List<String>> idsForSimplifiedQuery(CommonExpression expr) {
        if (expr instanceof OrExpression) {
            OrExpression orExpr = (OrExpression)expr;
            Optional<List<String>> lhs = ODataUtils.idsForSimplifiedQuery((CommonExpression)orExpr.getLHS());
            Optional<List<String>> rhs = ODataUtils.idsForSimplifiedQuery((CommonExpression)orExpr.getRHS());
            if (lhs.isPresent() && rhs.isPresent()) {
                return Optional.of(Stream.concat(lhs.get().stream(), rhs.get().stream()).collect(Collectors.toList()));
            }
        } else {
            if (expr instanceof ToLowerMethodCallExpression) {
                return ODataUtils.idsForSimplifiedQuery(((ToLowerMethodCallExpression)expr).getTarget());
            }
            if (expr instanceof ParenExpression) {
                return ODataUtils.idsForSimplifiedQuery(((ParenExpression)expr).getExpression());
            }
            if (expr instanceof BoolParenExpression) {
                return ODataUtils.idsForSimplifiedQuery(((BoolParenExpression)expr).getExpression());
            }
            if (expr instanceof EqExpression) {
                EqExpression eqExpr = (EqExpression)expr;
                Optional<List<String>> lhs = ODataUtils.idsForSimplifiedQuery(eqExpr.getLHS());
                if (lhs.isPresent() && eqExpr.getRHS() instanceof StringLiteral) {
                    StringLiteral stringLiteral = (StringLiteral)eqExpr.getRHS();
                    return Optional.of(Stream.concat(lhs.get().stream(), Stream.of(stringLiteral.getValue())).collect(Collectors.toList()));
                }
            } else if (expr instanceof EntitySimpleProperty && "ID".equalsIgnoreCase(((EntitySimpleProperty)expr).getPropertyName())) {
                return Optional.of(Collections.emptyList());
            }
        }
        return Optional.empty();
    }

    private static String getSanitizedValue(Map<String, String> query, String key) {
        return StringUtils.strip((String)query.getOrDefault(key, ""), (String)"\" '");
    }

    private static class NugetJPQLGenerator
    extends JPQLGenerator {
        private static final String ID_FIELD = "component.ci_name";
        private static final String VERSION_FIELD = "component.version";
        private static final String OPERATOR_EQ = "=";
        private static final String OPERATOR_NE = "<>";
        private static final String OPERATOR_GE = ">=";
        private static final String OPERATOR_LE = "<=";
        private static final String OPERATOR_GT = ">";
        private static final String OPERATOR_LT = "<";
        private static final List<String> OPERATORS = ImmutableList.of((Object)"=", (Object)"<>", (Object)">=", (Object)"<=", (Object)">", (Object)"<");
        private static final String SINGLE_QUOTE = "'";
        private static final String DOUBLE_SINGLE_QUOTE = "''";
        private static final String SINGLE_SPACE = " ";
        private static final List<String> ID_ALTERNATIVES = NugetJPQLGenerator.buildAlternatives("component.ci_name");
        private static final List<String> VERSION_ALTERNATIVES = NugetJPQLGenerator.buildAlternatives("component.version");

        NugetJPQLGenerator(String primaryKeyName, String tableAlias, Map<String, String> fieldAliases) {
            super(primaryKeyName, tableAlias, fieldAliases);
        }

        public String toJpql(BoolCommonExpression expression) {
            String result = super.toJpql(expression);
            if (this.hasMatch(result, ID_FIELD, ID_ALTERNATIVES)) {
                return result.toLowerCase(Locale.ENGLISH);
            }
            if (this.hasMatch(result, VERSION_FIELD, VERSION_ALTERNATIVES)) {
                return result.toLowerCase(Locale.ENGLISH).replaceAll("^component.version", "LOWER(component.version)").replaceAll("component.version$", "LOWER(component.version)");
            }
            return result;
        }

        private boolean hasMatch(String result, String field, List<String> alternatives) {
            return this.hasStartingMatch(result, field, alternatives) || this.hasEndingMatch(result, field, alternatives);
        }

        private boolean hasStartingMatch(String result, String field, List<String> alternatives) {
            return result.startsWith(field) && result.endsWith(SINGLE_QUOTE) && alternatives.stream().filter(a -> a.startsWith(field) && result.startsWith((String)a)).anyMatch(a -> this.hasStringLiteralMatch(result.substring(a.length() - 1)));
        }

        private boolean hasEndingMatch(String result, String field, List<String> alternatives) {
            return result.endsWith(field) && result.startsWith(SINGLE_QUOTE) && alternatives.stream().filter(a -> a.endsWith(field) && result.endsWith((String)a)).anyMatch(a -> this.hasStringLiteralMatch(result.substring(0, result.length() - a.length() + 1)));
        }

        private boolean hasStringLiteralMatch(String result) {
            if (DOUBLE_SINGLE_QUOTE.equals(result)) {
                return true;
            }
            String stringPortion = result.replaceAll(DOUBLE_SINGLE_QUOTE, "");
            return stringPortion.length() >= 2 && stringPortion.startsWith(SINGLE_QUOTE) && stringPortion.endsWith(SINGLE_QUOTE) && !stringPortion.substring(1, stringPortion.length() - 1).contains(SINGLE_QUOTE);
        }

        private static List<String> buildAlternatives(String field) {
            return Collections.unmodifiableList(OPERATORS.stream().map(operator -> SINGLE_SPACE + operator + SINGLE_SPACE).flatMap(str -> Stream.of(String.valueOf(field) + str + SINGLE_QUOTE, SINGLE_QUOTE + str + field)).collect(Collectors.toList()));
        }
    }
}

