/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.sonatype.nexus.repository.nuget.odata.ODataFeedUtils;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public final class ODataTemplates {
    public static final String NUGET_ROOT = ODataTemplates.load("root.nuget");
    public static final String NUGET_META = ODataTemplates.load("meta.nuget");
    public static final String NUGET_FEED = ODataTemplates.load("feed.nuget");
    public static final String NUGET_ENTRY = ODataTemplates.load("entry.nuget");
    public static final String NUGET_ERROR = ODataTemplates.load("error.nuget");
    public static final String NUGET_INLINECOUNT = ODataTemplates.load("inlinecount.nuget");
    private static final Set<String> DATE_ELEMENTS = ImmutableSet.of((Object)"last_updated", (Object)"created", (Object)"published");
    private static final String NULL_PROPERTY = " m:null=\"true\">";

    private ODataTemplates() {
    }

    public static String interpolate(String template, Map<String, ?> data) {
        int i;
        StringBuilder xml = new StringBuilder(template);
        int j = 0;
        while ((i = xml.indexOf("${", j)) > 0 && i < (j = xml.indexOf("}", i))) {
            String key;
            Object value;
            if ((value = data.get(key = xml.substring(i + 2, j++))) != null) {
                String text = value instanceof Date ? ODataFeedUtils.datetime(((Date)value).getTime()) : (DATE_ELEMENTS.contains(key) && value instanceof Long ? ODataFeedUtils.datetime((Long)value) : value.toString());
                xml.replace(i, j, text);
                j = i + text.length();
                continue;
            }
            if (xml.charAt(--i) != '>') continue;
            xml.replace(i, j, NULL_PROPERTY);
            j = i + NULL_PROPERTY.length();
        }
        return xml.toString();
    }

    private static String load(String name) {
        try {
            return new String(Resources.toByteArray((URL)ODataTemplates.class.getResource(name)), "UTF-8");
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

