/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.odata.FrameworkName;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FrameworkNameUtils {
    private static final Map<String, String> KNOWN_IDENTIFIERS = new ImmutableMap.Builder().put((Object)"net", (Object)".NETFramework").put((Object)".net", (Object)".NETFramework").put((Object)"netframework", (Object)".NETFramework").put((Object)".netframework", (Object)".NETFramework").put((Object)"netcore", (Object)".NETCore").put((Object)".netcore", (Object)".NETCore").put((Object)"winrt", (Object)".NETCore").put((Object)".netmicroframework", (Object)".NETMicroFramework").put((Object)"netmf", (Object)".NETMicroFramework").put((Object)"sl", (Object)"Silverlight").put((Object)"silverlight", (Object)"Silverlight").put((Object)".netportable", (Object)".NETPortable").put((Object)"netportable", (Object)".NETPortable").put((Object)"portable", (Object)".NETPortable").put((Object)"wp", (Object)"WindowsPhone").put((Object)"windowsphone", (Object)"WindowsPhone").put((Object)"windowsphoneapp", (Object)"WindowsPhoneApp").put((Object)"wpa", (Object)"WindowsPhoneApp").put((Object)"windows", (Object)"Windows").put((Object)"win", (Object)"Windows").put((Object)"aspnet", (Object)"ASP.Net").put((Object)"asp.net", (Object)"ASP.Net").put((Object)"aspnetcore", (Object)"ASP.NetCore").put((Object)"asp.netcore", (Object)"ASP.NetCore").put((Object)"native", (Object)"native").put((Object)"dnx", (Object)"DNX").put((Object)"dnxcore", (Object)"DNXCore").put((Object)"dotnet", (Object)".NETPlatform").put((Object)".netplatform", (Object)".NETPlatform").put((Object)"netstandard", (Object)".NETStandard").put((Object)"netstandardapp", (Object)".NETStandardApp").put((Object)".netstandardapp", (Object)".NETStandardApp").put((Object)"netcoreapp", (Object)".NETCoreApp").put((Object)".netcoreapp", (Object)".NETCoreApp").put((Object)"uap", (Object)"UAP").put((Object)"monoandroid", (Object)"MonoAndroid").put((Object)"monotouch", (Object)"MonoTouch").put((Object)"monomac", (Object)"MonoMac").put((Object)"xamarin.ios", (Object)"Xamarin.IOS").put((Object)"xamarinios", (Object)"Xamarin.IOS").put((Object)"xamarin.mac", (Object)"Xamarin.Mac").put((Object)"xamarinmac", (Object)"Xamarin.Mac").put((Object)"xamarin.playstationthree", (Object)"Xamarin.PlayStation3").put((Object)"xamarinplaystationthree", (Object)"Xamarin.PlayStation3").put((Object)"xamarinpsthree", (Object)"Xamarin.PlayStation3").put((Object)"xamarin.playstationfour", (Object)"Xamarin.PlayStation4").put((Object)"xamarinplaystationfour", (Object)"Xamarin.PlayStation4").put((Object)"xamarinpsfour", (Object)"Xamarin.PlayStation4").put((Object)"xamarin.playstationvita", (Object)"Xamarin.PlayStationVita").put((Object)"xamarinplaystationvita", (Object)"Xamarin.PlayStationVita").put((Object)"xamarinpsvita", (Object)"Xamarin.PlayStationVita").put((Object)"xamarin.tvos", (Object)"Xamarin.TVOS").put((Object)"xamarintvos", (Object)"Xamarin.TVOS").put((Object)"xamarin.watchos", (Object)"Xamarin.WatchOS").put((Object)"xamarinwatchos", (Object)"Xamarin.WatchOS").put((Object)"xamarin.xboxthreesixty", (Object)"Xamarin.Xbox360").put((Object)"xamarinxboxthreesixty", (Object)"Xamarin.Xbox360").put((Object)"xamarin.xboxone", (Object)"Xamarin.XboxOne").put((Object)"xamarinxboxone", (Object)"Xamarin.XboxOne").build();
    private static final Map<String, String> KNOWN_PROFILES = new ImmutableMap.Builder().put((Object)"client", (Object)"Client").put((Object)"wp", (Object)"WindowsPhone").put((Object)"wp71", (Object)"WindowsPhone71").put((Object)"cf", (Object)"CompactFramework").put((Object)"full", (Object)"").build();
    private static final Map<FrameworkName, FrameworkName> FRAMEWORK_NAME_ALIASES = new ImmutableMap.Builder().put((Object)new FrameworkName("WindowsPhone", "0.0", ""), (Object)new FrameworkName("Silverlight", "3.0", "WindowsPhone")).put((Object)new FrameworkName("WindowsPhone", "7.0", ""), (Object)new FrameworkName("Silverlight", "3.0", "WindowsPhone")).put((Object)new FrameworkName("WindowsPhone", "7.1", ""), (Object)new FrameworkName("Silverlight", "4.0", "WindowsPhone71")).put((Object)new FrameworkName("WindowsPhone", "8.0", ""), (Object)new FrameworkName("Silverlight", "8.0", "WindowsPhone")).put((Object)new FrameworkName("WindowsPhone", "8.1", ""), (Object)new FrameworkName("Silverlight", "8.1", "WindowsPhone")).put((Object)new FrameworkName("Windows", "0.0", ""), (Object)new FrameworkName(".NETCore", "4.5", "")).put((Object)new FrameworkName("Windows", "8.0", ""), (Object)new FrameworkName(".NETCore", "4.5", "")).put((Object)new FrameworkName("Windows", "8.1", ""), (Object)new FrameworkName(".NETCore", "4.5.1", "")).build();
    private static final Map<String, String> FRAMEWORK_ABBREVIATIONS = new ImmutableMap.Builder().put((Object)".NETFramework", (Object)"net").put((Object)".NETMicroFramework", (Object)"netmf").put((Object)"DNX", (Object)"dnx").put((Object)"DNXCore", (Object)"dnxcore").put((Object)".NETPlatform", (Object)"dotnet").put((Object)".NETStandard", (Object)"netstandard").put((Object)".NETStandardApp", (Object)"netstandardapp").put((Object)".NETCoreApp", (Object)"netcoreapp").put((Object)"ASP.Net", (Object)"aspnet").put((Object)"ASP.NetCore", (Object)"aspnetcore").put((Object)"Silverlight", (Object)"sl").put((Object)".NETCore", (Object)"win").put((Object)"Windows", (Object)"win").put((Object)".NETPortable", (Object)"portable").put((Object)"WindowsPhone", (Object)"wp").put((Object)"WindowsPhoneApp", (Object)"wpa").put((Object)"Xamarin.IOS", (Object)"xamarinios").put((Object)"Xamarin.Mac", (Object)"xamarinmac").put((Object)"Xamarin.PlayStation3", (Object)"xamarinpsthree").put((Object)"Xamarin.PlayStation4", (Object)"xamarinpsfour").put((Object)"Xamarin.PlayStationVita", (Object)"xamarinpsvita").put((Object)"Xamarin.TVOS", (Object)"xamarintvos").put((Object)"Xamarin.WatchOS", (Object)"xamarinwatchos").put((Object)"Xamarin.Xbox360", (Object)"xamarinxboxthreesixty").put((Object)"Xamarin.XboxOne", (Object)"xamarinxboxone").build();
    private static final Map<String, String> PROFILE_ABBREVIATIONS = new ImmutableMap.Builder().put((Object)"WindowsPhone", (Object)"wp").put((Object)"WindowsPhone71", (Object)"wp71").put((Object)"CompactFramework", (Object)"cf").build();
    private static final Pattern VERSION_EXTRACTOR_PATTERN = Pattern.compile("\\d+");
    private static final Pattern VERSION_VALIDATOR_PATTERN = Pattern.compile("\\d+(\\.\\d+){0,3}");

    private FrameworkNameUtils() {
    }

    public static String convertToShortName(String frameworkName) throws NugetPackageException {
        FrameworkName parsedName = FrameworkNameUtils.parseFrameworkName(frameworkName);
        return FrameworkNameUtils.buildShortFrameworkName(parsedName);
    }

    public static FrameworkName parseFrameworkName(String frameworkName) throws NugetPackageException {
        Preconditions.checkNotNull((Object)frameworkName);
        String[] components = frameworkName.split("-");
        if (components.length > 2) {
            throw new NugetPackageException("Invalid framework name format: " + frameworkName);
        }
        String identifierAndVersionPart = FrameworkNameUtils.extractIdentifierAndVersionPart(components);
        String profilePart = FrameworkNameUtils.extractProfilePart(components);
        if (identifierAndVersionPart.isEmpty()) {
            throw new NugetPackageException("Framework name not specified: " + identifierAndVersionPart);
        }
        String identifier = FrameworkNameUtils.parseFrameworkNameIdentifier(identifierAndVersionPart);
        String version = FrameworkNameUtils.parseFrameworkNameVersion(identifier, identifierAndVersionPart);
        String profile = FrameworkNameUtils.parseFrameworkNameProfile(identifier, profilePart);
        if (version == null) {
            return FrameworkName.UNSUPPORTED;
        }
        return new FrameworkName(identifier, version, profile);
    }

    private static String extractIdentifierAndVersionPart(String[] components) {
        return components.length > 0 ? components[0].trim() : "";
    }

    private static String extractProfilePart(String[] components) {
        return components.length > 1 ? components[1].trim() : "";
    }

    private static String parseFrameworkNameIdentifier(String identifierAndVersionPart) {
        String identifier = identifierAndVersionPart;
        Matcher versionMatcher = VERSION_EXTRACTOR_PATTERN.matcher(identifierAndVersionPart);
        if (versionMatcher.find()) {
            identifier = identifierAndVersionPart.substring(0, versionMatcher.start()).trim();
        }
        if (!identifier.isEmpty()) {
            identifier = KNOWN_IDENTIFIERS.getOrDefault(identifier.toLowerCase(), identifier);
        }
        if (identifier.isEmpty()) {
            identifier = ".NETFramework";
        }
        return identifier;
    }

    private static String parseFrameworkNameVersion(String identifier, String identifierAndVersionPart) {
        String version = "";
        Matcher versionMatcher = VERSION_EXTRACTOR_PATTERN.matcher(identifierAndVersionPart);
        if (versionMatcher.find()) {
            version = identifierAndVersionPart.substring(versionMatcher.start()).trim();
        }
        if (VERSION_EXTRACTOR_PATTERN.matcher(version).matches()) {
            if (version.length() > 4) {
                version = version.substring(0, 4);
            }
            version = String.join((CharSequence)".", Strings.padEnd((String)version, (int)2, (char)'0').split(""));
        }
        if (!VERSION_VALIDATOR_PATTERN.matcher(version).matches()) {
            version = Strings.isNullOrEmpty((String)identifier) || !version.isEmpty() ? null : "0.0.0.0";
        }
        return version;
    }

    private static String parseFrameworkNameProfile(String identifier, String profilePart) throws NugetPackageException {
        String profile = profilePart;
        if (!profile.isEmpty()) {
            profile = KNOWN_PROFILES.getOrDefault(profile.toLowerCase(), profile);
        }
        if (".NETPortable".equalsIgnoreCase(identifier) && !profile.isEmpty()) {
            LinkedHashSet<String> profileParts = new LinkedHashSet<String>();
            String[] stringArray = profile.split("\\+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                profileParts.add(FrameworkNameUtils.convertToShortName(part));
                ++n2;
            }
            profile = String.join((CharSequence)"+", profileParts);
        }
        return profile;
    }

    public static String buildShortFrameworkName(FrameworkName frameworkName) {
        Preconditions.checkNotNull((Object)frameworkName);
        FrameworkName matchedFrameworkName = FrameworkNameUtils.matchFrameworkWithAlias(frameworkName);
        String name = FRAMEWORK_ABBREVIATIONS.getOrDefault(matchedFrameworkName.getIdentifier(), matchedFrameworkName.getIdentifier());
        String version = "";
        String profile = "";
        if ("portable".equalsIgnoreCase(name)) {
            profile = matchedFrameworkName.getProfile();
        } else {
            if (!"0.0.0.0".equals(matchedFrameworkName.getVersion())) {
                version = matchedFrameworkName.getVersion().replace(".", "");
            }
            profile = PROFILE_ABBREVIATIONS.getOrDefault(matchedFrameworkName.getProfile(), matchedFrameworkName.getProfile());
        }
        String shortName = String.valueOf(name) + version;
        if (!profile.isEmpty()) {
            shortName = String.valueOf(shortName) + "-" + profile;
        }
        return shortName;
    }

    private static FrameworkName matchFrameworkWithAlias(FrameworkName frameworkName) {
        Optional<Map.Entry<FrameworkName, FrameworkName>> matchingAlias = FrameworkNameUtils.findMatchingAlias(frameworkName);
        if (matchingAlias.isPresent()) {
            return matchingAlias.get().getKey();
        }
        return frameworkName;
    }

    private static Optional<Map.Entry<FrameworkName, FrameworkName>> findMatchingAlias(FrameworkName frameworkName) {
        return FRAMEWORK_NAME_ALIASES.entrySet().stream().filter(each -> {
            FrameworkName other = (FrameworkName)each.getValue();
            if (!other.getIdentifier().equalsIgnoreCase(frameworkName.getIdentifier())) {
                return false;
            }
            if (!other.getVersion().equals(frameworkName.getVersion())) {
                return false;
            }
            return other.getVersion().isEmpty() || other.getVersion().equals(frameworkName.getVersion());
        }).findFirst();
    }
}

