/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Version;
import java.util.Comparator;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.VersionComparator;

public class NugetV3SemVerComparator
extends ComponentSupport
implements Comparator<String> {
    public static final NugetV3SemVerComparator INSTANCE = new NugetV3SemVerComparator();

    private NugetV3SemVerComparator() {
    }

    @Override
    public int compare(String version1, String version2) {
        if (version1 == null) {
            return -1;
        }
        if (version2 == null) {
            return 1;
        }
        if (version1.equals(version2)) {
            return 0;
        }
        try {
            int compare = Version.valueOf((String)version1).compareTo(Version.valueOf((String)version2));
            return Integer.signum(compare);
        }
        catch (ParseException | IllegalArgumentException throwable) {
            this.log.trace("Can't compare versions {} and {} according SemVer comparator, using general comparator", (Object)version1, (Object)version2);
            String v1 = this.removeBuild(version1);
            String v2 = this.removeBuild(version2);
            int compare = VersionComparator.INSTANCE.compare(v1, v2);
            return Integer.signum(compare);
        }
    }

    private String removeBuild(String version) {
        int index = version.indexOf("+");
        if (index != -1) {
            return version.substring(0, index);
        }
        return version;
    }
}

