/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.view.Parameters;

public class NugetV3SearchParam {
    private static final int DEFAULT_SKIP = 0;
    private static final int DEFAULT_TAKE = 10;
    private static final String DEFAULT_SEMVER = "1.0.0";
    private static final boolean DEFAULT_PRERELEASE = false;
    private final String q;
    private final int skip;
    private final int take;
    private final boolean prerelease;
    private final String semVerLevel;

    private NugetV3SearchParam(@Nullable String q, int skip, int take, boolean prerelease, String semVerLevel) {
        Objects.requireNonNull(semVerLevel);
        this.q = q;
        this.skip = skip;
        this.take = take;
        this.prerelease = prerelease;
        this.semVerLevel = semVerLevel;
    }

    @Nullable
    public String getQ() {
        return this.q;
    }

    public int getSkip() {
        return this.skip;
    }

    public int getTake() {
        return this.take;
    }

    public boolean getPrerelease() {
        return this.prerelease;
    }

    public String getSemVerLevel() {
        return this.semVerLevel;
    }

    public static NugetV3SearchParam build(Parameters parameters) {
        String q = parameters.get("q");
        String skip = parameters.get("skip");
        String take = parameters.get("take");
        String prerelease = parameters.get("prerelease");
        String semVerLevel = parameters.get("semVerLevel");
        return NugetV3SearchParam.build(StringUtils.isEmpty((CharSequence)q) ? null : q, StringUtils.isEmpty((CharSequence)skip) ? null : Integer.valueOf(skip), StringUtils.isEmpty((CharSequence)take) ? null : Integer.valueOf(take), StringUtils.isEmpty((CharSequence)prerelease) ? null : Boolean.valueOf(prerelease), semVerLevel);
    }

    public static NugetV3SearchParam build(@Nullable String q, @Nullable Integer skip, @Nullable Integer take, @Nullable Boolean prerelease, @Nullable String semVerLevel) {
        return new NugetV3SearchParam(q, skip == null ? 0 : skip, take == null ? 10 : take, prerelease == null ? false : prerelease, semVerLevel == null ? DEFAULT_SEMVER : semVerLevel);
    }
}

