/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SearchParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SortDirection;

@Facet.Exposed
public class NugetV3SearchFacet
extends FacetSupport {
    private static final String ASSET_ATTRIBUTE_PREFIX = "assets.attributes.nuget.";
    private static final String P_PACKAGE_ID = "packageid";
    private static final String AUTHOR = "author";
    private static final Map<String, String> EXACT_FIELDS = ImmutableMap.of((Object)"packageid", (Object)"assets.attributes.nuget.id");
    private static final Map<String, String> MATCH_FIELDS = ImmutableMap.builder().put((Object)"id", (Object)"assets.attributes.nuget.id").put((Object)"title", (Object)"assets.attributes.nuget.title").put((Object)"tags", (Object)"assets.attributes.nuget.tags").put((Object)"authors", (Object)"assets.attributes.nuget.authors").put((Object)"author", (Object)"assets.attributes.nuget.authors").put((Object)"description", (Object)"assets.attributes.nuget.description").put((Object)"summary", (Object)"assets.attributes.nuget.summary").build();
    private static final Map<String, String> FIELDS = ImmutableMap.builder().putAll(EXACT_FIELDS).putAll(MATCH_FIELDS).build();
    private static final Set<String> KEYWORDS_FIELDS = ImmutableSet.copyOf(FIELDS.values());
    private final SearchService searchService;

    @Inject
    public NugetV3SearchFacet(SearchService searchService) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
    }

    public List<ComponentSearchResult> search(NugetV3SearchParam searchParam) {
        QueryTerms queryTerms = QueryTerms.extract(searchParam.getQ());
        SearchRequest.Builder requestBuilder = this.buildQuery(queryTerms).repository(this.getRepository().getName()).sortField("assets.attributes.nuget.id").sortDirection(SortDirection.ASC);
        SearchRequest request = requestBuilder.build();
        if (request.getSearchFilters().isEmpty() && searchParam.getPrerelease()) {
            return Collections.emptyList();
        }
        List results = this.searchService.search(request).getSearchResults();
        if (!searchParam.getPrerelease()) {
            results = results.stream().filter(NugetV3SearchFacet::isRelease).collect(Collectors.toList());
        }
        int skip = searchParam.getSkip();
        int take = searchParam.getTake();
        int start = Math.max(0, skip);
        int end = Math.min(start + take, results.size());
        return results.subList(start, end);
    }

    private static boolean isRelease(ComponentSearchResult result) {
        return result.getAssets().stream().findAny().map(AssetSearchResult::getAttributes).map(attr -> attr.get("nuget")).filter(Map.class::isInstance).map(Map.class::cast).map(nugetAttr -> nugetAttr.get("is_prerelease")).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false) == false;
    }

    @VisibleForTesting
    SearchRequest.Builder buildQuery(QueryTerms queryTerms) {
        List<Term> terms = queryTerms.getTerms().stream().filter(term -> FIELDS.containsKey(term.getProperty())).collect(Collectors.toList());
        SearchRequest.Builder request = SearchRequest.builder();
        if (terms.isEmpty() && queryTerms.getKeywords().isEmpty()) {
            return request;
        }
        List uniqueProperties = terms.stream().map(Term::getProperty).distinct().collect(Collectors.toList());
        if (uniqueProperties.size() != terms.size()) {
            request.disjunction();
        }
        terms.forEach(term -> {
            String property = term.getProperty();
            String elasticProperty = FIELDS.get(property);
            if (EXACT_FIELDS.containsKey(property)) {
                request.searchFilter(elasticProperty, term.getTerm());
            } else {
                request.searchFilter(elasticProperty, String.format("*%s*", term.getTerm()));
            }
        });
        Set<String> keywords = queryTerms.getKeywords();
        if (CollectionUtils.isEmpty(terms) && CollectionUtils.isNotEmpty(keywords)) {
            request.disjunction();
            queryTerms.getKeywords().stream().map(searchKeyword -> "*" + searchKeyword + "*").forEach(term -> KEYWORDS_FIELDS.forEach(field -> {
                SearchRequest.Builder builder2 = request.searchFilter(field, term);
            }));
        }
        return request;
    }

    public static class QueryTerms {
        private static final Pattern TERM_PATTERN = Pattern.compile("(?:^|\\s)(?:([^:\"\\s]*):)?([^\\s]+)");
        public static final QueryTerms EMPTY = new QueryTerms(Collections.emptySet(), Collections.emptyList());
        private final Set<String> keywords;
        private final List<Term> terms;

        private QueryTerms(Set<String> keywords, List<Term> terms) {
            Objects.requireNonNull(keywords, "Keywords is required");
            Objects.requireNonNull(terms, "Terms is required");
            this.keywords = keywords;
            this.terms = terms;
        }

        public Set<String> getKeywords() {
            return this.keywords;
        }

        public List<Term> getTerms() {
            return this.terms;
        }

        public static QueryTerms extract(@Nullable String q) {
            if (StringUtils.isEmpty((CharSequence)q)) {
                return EMPTY;
            }
            Matcher termMatcher = TERM_PATTERN.matcher(q);
            LinkedHashSet<String> searchKeywords = new LinkedHashSet<String>();
            ArrayList<Term> terms = new ArrayList<Term>();
            while (termMatcher.find()) {
                String term;
                String property = termMatcher.group(1);
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{property, term = QueryTerms.removeQuoteMark(termMatcher.group(2))})) {
                    String propertyLower = property.toLowerCase();
                    terms.add(new Term(propertyLower, term));
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)term) || term.endsWith(":")) continue;
                searchKeywords.add(term);
            }
            return new QueryTerms(searchKeywords, terms);
        }

        private static String removeQuoteMark(@Nullable String value) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return value;
            }
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            return value;
        }
    }

    public static class Term {
        private final String property;
        private final String term;

        public Term(String property, String term) {
            this.property = property;
            this.term = term;
        }

        public String getProperty() {
            return this.property;
        }

        public String getTerm() {
            return this.term;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Term term1 = (Term)o;
            return Objects.equals(this.property, term1.property) && Objects.equals(this.term, term1.term);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.term);
        }
    }
}

