/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetRouteConstants;
import com.sonatype.nexus.repository.nuget.v3.PackageBaseAddress;
import com.sonatype.nexus.repository.nuget.v3.RegistrationsBaseUrl;
import com.sonatype.nexus.repository.nuget.v3.models.PageLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.RepositorySignaturesIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.sonatype.nexus.repository.view.Context;

public final class NugetV3ProxyUtil {
    private static final String INDEX_JSON = "index.json";
    private static final String HTTPS = "https";

    private NugetV3ProxyUtil() {
    }

    public static ServiceIndex buildNxrmServiceIndex(ServiceIndex serviceIndex, String repositoryUrl) {
        ServiceIndex result = new ServiceIndex();
        result.setVersion(serviceIndex.getVersion());
        result.setResources(serviceIndex.getResources().stream().filter(serviceResource -> {
            if (!repositoryUrl.startsWith(HTTPS)) {
                return !serviceResource.getType().startsWith("RepositorySignatures");
            }
            return true;
        }).map(resource -> {
            ServiceResource serviceResource = new ServiceResource();
            serviceResource.setId(resource.getId());
            serviceResource.setType(resource.getType());
            serviceResource.setComment(resource.getComment());
            serviceResource.setRemoteUrl(resource.getRemoteUrl());
            return serviceResource;
        }).collect(Collectors.toList()));
        NugetV3ProxyUtil.rewriteServiceResourcesIds(result, repositoryUrl);
        NugetV3ProxyUtil.maybeAttachRegistrationsBaseUrlVersionedBaseOnRegistrationsBaseUrl340(result);
        return result;
    }

    private static void maybeAttachRegistrationsBaseUrlVersionedBaseOnRegistrationsBaseUrl340(ServiceIndex serviceIndex) {
        Optional<ServiceResource> registrationBaseURLVersioned = serviceIndex.resourceByType(RegistrationsBaseUrl.REGISTRATIONS_BASE_URL_VERSIONED);
        if (!registrationBaseURLVersioned.isPresent()) {
            serviceIndex.resourceByType(RegistrationsBaseUrl.REGISTRATIONS_BASE_URL_3_4_0).ifPresent(serviceResource340 -> {
                ServiceResource serviceResourceVersioned = new ServiceResource();
                serviceResourceVersioned.setId(serviceResource340.getId());
                serviceResourceVersioned.setType(RegistrationsBaseUrl.REGISTRATIONS_BASE_URL_VERSIONED.getType());
                serviceIndex.getResources().add(serviceResourceVersioned);
            });
        }
    }

    @VisibleForTesting
    static void rewriteServiceResourcesIds(ServiceIndex serviceIndex, String repositoryUrl) {
        NugetRouteConstants.REWRITE_PATH_BY_RESOURCE.forEach((resourceName, nxrmPath) -> NugetV3ProxyUtil.rewriteIds(serviceIndex.resourcesByName((String)resourceName), repositoryUrl, nxrmPath));
        NugetV3ProxyUtil.rewriteRepositorySignaturesIds(serviceIndex.resourcesByName("RepositorySignatures"), repositoryUrl, "/v3/repository-signatures/");
    }

    @VisibleForTesting
    static void rewriteIds(List<ServiceResource> resources, String repositoryUrl, String rewritePath) {
        int i = 0;
        while (i < resources.size()) {
            ServiceResource serviceResource = resources.get(i);
            if (StringUtils.isBlank((CharSequence)serviceResource.getRemoteUrl())) {
                serviceResource.setRemoteUrl(NugetV3ProxyUtil.trimSlashes(serviceResource.getId()));
            }
            String resourceSuffix = String.valueOf(i);
            serviceResource.setId(NugetV3ProxyUtil.joinPath(repositoryUrl, rewritePath, resourceSuffix));
            ++i;
        }
    }

    static void rewriteRepositorySignaturesIds(List<ServiceResource> resources, String repositoryUrl, String rewritePath) {
        NugetV3ProxyUtil.rewriteIds(resources, repositoryUrl, rewritePath);
        resources.forEach(serviceResource -> {
            String id = serviceResource.getId();
            serviceResource.setId(NugetV3ProxyUtil.joinPath(id, INDEX_JSON));
        });
    }

    public static Optional<String> buildProxyUrlOptional(String fullRemoteUrl, ServiceIndex serviceIndex) {
        return NugetV3ProxyUtil.getResourceForRemote(fullRemoteUrl, serviceIndex).map(r -> NugetV3ProxyUtil.joinPath(r.getId(), fullRemoteUrl.substring(r.getRemoteUrl().length())));
    }

    public static String buildProxyUrl(String fullRemoteUrl, ServiceIndex serviceIndex) {
        return NugetV3ProxyUtil.buildProxyUrlOptional(fullRemoteUrl, serviceIndex).orElse(fullRemoteUrl);
    }

    public static Optional<ServiceResource> getResourceForRemote(String remoteUrl, ServiceIndex serviceIndex) {
        return serviceIndex.getResources().stream().filter(r -> StringUtils.isNotEmpty((CharSequence)r.getRemoteUrl())).filter(r -> remoteUrl.startsWith(String.valueOf(r.getRemoteUrl()) + "/")).findFirst();
    }

    public static URI buildRemoteUri(Context context) throws URISyntaxException {
        return NugetV3ProxyUtil.buildRemoteUri(context, null);
    }

    public static URI buildRemoteUri(Context context, @Nullable String additionalPath) throws URISyntaxException {
        return NugetV3ProxyUtil.buildRemoteUriOptional(context, additionalPath).orElseThrow(() -> new RuntimeException("No matched resource in service index for path: " + context.getRequest().getPath()));
    }

    public static Optional<URI> buildRemoteUriOptional(Context context, @Nullable String additionalPath) throws URISyntaxException {
        Optional<String> remoteServiceUrl = NugetV3ProxyUtil.getRemoteServiceUrlOptional(context);
        if (!remoteServiceUrl.isPresent()) {
            return Optional.empty();
        }
        URIBuilder remoteBuilder = new URIBuilder(NugetV3ProxyUtil.joinPath(remoteServiceUrl.get(), additionalPath));
        context.getRequest().getParameters().forEach(p -> {
            URIBuilder uRIBuilder2 = remoteBuilder.addParameter((String)p.getKey(), (String)p.getValue());
        });
        return Optional.of(remoteBuilder.build());
    }

    private static Optional<String> getRemoteServiceUrlOptional(Context context) {
        String requestPath = context.getRequest().getPath();
        String repoName = context.getRepository().getName();
        return ((ServiceIndex)context.getAttributes().require(ServiceIndex.class)).getResources().stream().filter(r -> StringUtils.isNotEmpty((CharSequence)r.getRemoteUrl())).filter(r -> requestPath.startsWith(NugetV3ProxyUtil.resourcePath(r, repoName))).map(ServiceResource::getRemoteUrl).findFirst();
    }

    static String resourcePath(ServiceResource serviceResource, String repositoryName) {
        if (!serviceResource.getId().contains(repositoryName)) {
            return URI.create(serviceResource.getId()).getPath();
        }
        return serviceResource.getId().substring(serviceResource.getId().indexOf(repositoryName) + repositoryName.length());
    }

    public static String joinPath(String ... parts) {
        StringJoiner joiner = new StringJoiner("/");
        Arrays.stream(parts).filter(StringUtils::isNotBlank).forEach(p -> {
            StringJoiner stringJoiner2 = joiner.add(NugetV3ProxyUtil.trimSlashes(p));
        });
        return joiner.toString();
    }

    public static String trimSlashes(String s) {
        String trimmed = s.trim();
        return StringUtils.removeStart((String)(trimmed.endsWith("/") ? StringUtils.chop((String)trimmed) : trimmed), (String)"/");
    }

    public static String buildRepositorySignaturesCertificatesContentUrl(String repositoryUrl, String contentFingerprint, String repositorySignaturesNxrmPath) {
        String suffix = NugetV3ProxyUtil.joinPath(repositorySignaturesNxrmPath, "certificates", contentFingerprint);
        return String.valueOf(repositoryUrl) + "/" + suffix + ".crt";
    }

    public static void rewriteRepositorySignaturesIndex(RepositorySignaturesIndex repositorySignaturesIndex, String repositorySignaturesPath, String repositoryURL) {
        repositorySignaturesIndex.getSigningCertificates().forEach(certificate -> {
            String contentFingerprint = certificate.getFingerprints().getValue();
            String nxrmContentURL = NugetV3ProxyUtil.buildRepositorySignaturesCertificatesContentUrl(repositoryURL, contentFingerprint, repositorySignaturesPath);
            certificate.setContentUrl(nxrmContentURL);
        });
    }

    public static String buildPackageContentURL(String serviceResourceId, String packageId, String packageVersion) {
        String id = StringUtils.appendIfMissing((String)serviceResourceId, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return String.valueOf(id) + packageId + "/" + packageVersion + "/" + packageId + "." + packageVersion + ".nupkg";
    }

    public static String rewritePageId(String remotePageId, ServiceIndex serviceIndex) {
        if (remotePageId.contains("#page/")) {
            return NugetV3ProxyUtil.getResourceForRemote(remotePageId, serviceIndex).map(resource -> NugetV3ProxyUtil.joinPath(resource.getId(), remotePageId.substring(resource.getRemoteUrl().length()))).orElse(remotePageId);
        }
        return NugetV3ProxyUtil.getResourceForRemote(remotePageId, serviceIndex).map(resource -> NugetV3ProxyUtil.joinPath(resource.getId(), "page", remotePageId.substring(resource.getRemoteUrl().length()))).orElse(remotePageId);
    }

    public static String extractRelativeRegistrationPagePath(String nxrmRegistrationPageRequestPath) {
        return nxrmRegistrationPageRequestPath.replaceAll("/v3/registration/(?:\\d+\\/)?page/", "");
    }

    public static String buildRelativeRegistrationIndexNxrmRequestPath(String repositoryUrl, String registrationsBaseUrlServiceResourceId, String packageId) {
        String serviceResourceNxrmPath = registrationsBaseUrlServiceResourceId.replaceAll(repositoryUrl, "");
        serviceResourceNxrmPath = StringUtils.appendIfMissing((String)serviceResourceNxrmPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        serviceResourceNxrmPath = StringUtils.prependIfMissing((String)serviceResourceNxrmPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        return String.valueOf(serviceResourceNxrmPath) + packageId + "/index.json";
    }

    public static void rewritePageLeafUrls(String repositoryUrl, PageLeaf leaf, ServiceIndex serviceIndex) {
        leaf.setId(NugetV3ProxyUtil.buildProxyUrl(leaf.getId(), serviceIndex));
        Optional<String> proxyPackageContent = NugetV3ProxyUtil.buildProxyUrlOptional(leaf.getPackageContent(), serviceIndex);
        if (proxyPackageContent.isPresent()) {
            leaf.setPackageContent(proxyPackageContent.get());
        } else {
            String packageId = leaf.getCatalogEntry().getId();
            String packageVersion = leaf.getCatalogEntry().getVersion();
            if (StringUtils.isEmpty((CharSequence)packageId) || StringUtils.isEmpty((CharSequence)packageVersion)) {
                return;
            }
            String serviceResourceId = String.valueOf(repositoryUrl) + PackageBaseAddress.PACKAGE_BASE_ADDRESS.getPath();
            String packageContent = NugetV3ProxyUtil.buildPackageContentURL(serviceResourceId, packageId.toLowerCase(), packageVersion.toLowerCase());
            leaf.setPackageContent(packageContent);
        }
    }

    public static ServiceIndex toUpstreamServiceIndex(ServiceIndex serviceIndex) {
        ServiceIndex upstream = new ServiceIndex();
        upstream.setVersion(serviceIndex.getVersion());
        upstream.setResources(serviceIndex.getResources().stream().map(serviceResource -> {
            ServiceResource upstreamServiceResource = new ServiceResource();
            upstreamServiceResource.setId(serviceResource.getId());
            upstreamServiceResource.setType(serviceResource.getType());
            upstreamServiceResource.setComment(serviceResource.getComment());
            return upstreamServiceResource;
        }).collect(Collectors.toList()));
        return upstream;
    }
}

