/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyRepositorySignaturesFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetMetadataMatcher;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.models.RepositorySignaturesIndex;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class NugetV3ProxyRepositorySignaturesCertificatesHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Optional<RepositorySignaturesIndex> repositorySignaturesIndex = this.getRepositorySignaturesIndex(context);
        if (!repositorySignaturesIndex.isPresent()) {
            this.log.debug("RepositorySignaturesIndex not found; will try to proxy this file");
            Context contextRepositorySignaturesIndex = this.buildContextForRepositorySignaturesIndexRequest(context);
            Content content = ((ProxyFacet)context.getRepository().facet(ProxyFacet.class)).get(contextRepositorySignaturesIndex);
            if (content != null) {
                repositorySignaturesIndex = this.getRepositorySignaturesIndex(context);
            }
        }
        context.getAttributes().set(RepositorySignaturesIndex.class, (Object)repositorySignaturesIndex.orElse(null));
        return context.proceed();
    }

    private Optional<RepositorySignaturesIndex> getRepositorySignaturesIndex(Context context) throws IOException {
        Repository repository = context.getRepository();
        NugetV3ProxyRepositorySignaturesFacet facet = (NugetV3ProxyRepositorySignaturesFacet)repository.facet(NugetV3ProxyRepositorySignaturesFacet.class);
        String assetPath = NugetMetadataMatcher.getRepositorySignaturesSuffixId(context);
        return facet.getRepositorySignaturesIndex(assetPath);
    }

    private Context buildContextForRepositorySignaturesIndexRequest(Context contextCertificates) {
        Repository repository = contextCertificates.getRepository();
        String requestPath = NugetMetadataMatcher.getRepositorySignaturesSuffixId(contextCertificates);
        Request request = new Request.Builder().action(contextCertificates.getRequest().getAction()).path(requestPath).build();
        Context repositorySignaturesIndexContext = new Context(repository, request);
        repositorySignaturesIndexContext.getAttributes().backing().putAll(contextCertificates.getAttributes().backing());
        repositorySignaturesIndexContext.getAttributes().set(AssetKind.class, (Object)AssetKind.REPOSITORY_SIGNATURES);
        return repositorySignaturesIndexContext;
    }
}

