/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.NugetDataUtils;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyMetadataProvider;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.PageLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceResource;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;

@Named
@Facet.Exposed
public class NugetV3ProxyPackageContentFacet
extends FacetSupport {
    private final NugetV3ProxyMetadataProvider metadataProvider;

    @Inject
    public NugetV3ProxyPackageContentFacet(NugetV3ProxyMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    public Optional<String> lookForPackageContentUrlInMetadataFiles(String packageId, String packageVersion) throws IOException {
        NugetV3ServiceIndexFacet serviceIndexFacet = (NugetV3ServiceIndexFacet)this.facet(NugetV3ServiceIndexFacet.class);
        ServiceIndex serviceIndex = serviceIndexFacet.getServiceIndex();
        List<ServiceResource> registrationsBaseUrlServiceResources = this.getRegistrationsBaseUrlServiceResources(serviceIndex);
        for (ServiceResource serviceResource : registrationsBaseUrlServiceResources) {
            Optional<String> packageContentUrl = this.lookForPackageContentUrlInTheMetadata(serviceResource, packageId, packageVersion);
            if (!packageContentUrl.isPresent()) continue;
            return packageContentUrl;
        }
        return Optional.empty();
    }

    private Optional<String> lookForPackageContentUrlInTheMetadata(ServiceResource serviceResource, String packageId, String packageVersion) throws IOException {
        Repository repository = this.getRepository();
        List<PageLeaf> pageLeaves = this.metadataProvider.getOriginalPageLeaves(repository, serviceResource, packageId);
        return this.lookForPackageContentInOriginalPageLeaves(pageLeaves, packageId, packageVersion);
    }

    private Optional<String> lookForPackageContentInOriginalPageLeaves(List<PageLeaf> pageLeaves, String packageId, String packageVersion) {
        for (PageLeaf leaf : pageLeaves) {
            String entryPackageId = leaf.getCatalogEntry().getId();
            String entryPackageVersion = leaf.getCatalogEntry().getVersion();
            if (packageId.equalsIgnoreCase(entryPackageId) && entryPackageVersion.equalsIgnoreCase(packageVersion)) {
                String packageContent = leaf.getPackageContent();
                return Optional.of(packageContent);
            }
            String normalizedVersion = NugetDataUtils.buildNormalizeVersion(entryPackageVersion).orElse(null);
            if (!packageId.equalsIgnoreCase(entryPackageId) || !packageVersion.equalsIgnoreCase(normalizedVersion)) continue;
            String packageContent = leaf.getPackageContent();
            return Optional.of(packageContent);
        }
        return Optional.empty();
    }

    private List<ServiceResource> getRegistrationsBaseUrlServiceResources(ServiceIndex serviceIndex) {
        return serviceIndex.resourcesByName("RegistrationsBaseUrl").stream().sorted((o1, o2) -> Comparator.reverseOrder().compare(o1.getType(), o2.getType())).collect(Collectors.toList());
    }
}

