/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacetImpl;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceResource;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class NugetV3HostedServiceIndexFacetImpl
extends NugetV3ServiceIndexFacetImpl {
    private static final String REGISTRATION_PATH = "/v3/registration/";
    private static final String PUBLISH_PATH = "";
    private static final String LEGACY_GALLERY_PATH = "";
    private static final List<String> REGISTRATION_SERVICE_TYPES = ImmutableList.builder().add((Object)"RegistrationsBaseUrl").add((Object)"RegistrationsBaseUrl/3.4.0").add((Object)"RegistrationsBaseUrl/3.6.0").add((Object)"RegistrationsBaseUrl/Versioned").build();

    @Override
    protected List<ServiceResource> getRegistrationBaseUrlResources() {
        return REGISTRATION_SERVICE_TYPES.stream().map(type -> {
            String id = String.valueOf(this.getRepository().getUrl()) + REGISTRATION_PATH;
            return this.buildResource((String)type, id);
        }).collect(Collectors.toList());
    }

    @Override
    protected List<ServiceResource> getOtherServiceResources() {
        return Arrays.asList(this.getPackagePublishResource(), this.getLegacyGalleryResource());
    }

    private ServiceResource getPackagePublishResource() {
        String path = String.valueOf(this.getRepository().getUrl());
        return this.buildResource("PackagePublish/2.0.0", path);
    }

    private ServiceResource getLegacyGalleryResource() {
        String path = String.valueOf(this.getRepository().getUrl());
        return this.buildResource("LegacyGallery/2.0.0", path);
    }
}

