/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.collect.Lists;
import com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata.NugetRegistrationsUtils;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResponse;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResult;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResultVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;

public class NugetV3HostedSearchResponseProcessor {
    private NugetV3HostedSearchResponseProcessor() {
    }

    public static SearchResponse process(String repositoryUrl, List<ComponentSearchResult> hits) {
        LinkedHashMap<String, SearchResult> searchResultMap = new LinkedHashMap<String, SearchResult>();
        for (ComponentSearchResult searchHit : hits) {
            for (AssetSearchResult asset : searchHit.getAssets()) {
                Map attributes = asset.getAttributes();
                Map assetNugetAttributes = (Map)attributes.get("nuget");
                String id = (String)assetNugetAttributes.get("id");
                SearchResult searchResult = searchResultMap.computeIfAbsent(id, key -> {
                    SearchResult next = new SearchResult();
                    next.setVersions(new ArrayList<SearchResultVersion>());
                    return next;
                });
                NugetV3HostedSearchResponseProcessor.populateSearchResultVersion(repositoryUrl, searchResult, assetNugetAttributes);
                String version = (String)assetNugetAttributes.get("version");
                String searchResultVersion = searchResult.getVersion();
                if (searchResultVersion != null && VersionComparator.INSTANCE.compare(version, searchResultVersion) <= 0) continue;
                NugetV3HostedSearchResponseProcessor.populateRequiredFields(repositoryUrl, assetNugetAttributes, searchResult);
            }
        }
        ArrayList data = Lists.newArrayList(searchResultMap.values());
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setTotalHits(data.size());
        searchResponse.setData(data);
        return searchResponse;
    }

    private static void populateSearchResultVersion(String repositoryUrl, SearchResult searchResult, Map<String, Object> assetNugetAttributes) {
        String id = (String)assetNugetAttributes.get("id");
        String version = (String)assetNugetAttributes.get("version");
        SearchResultVersion resultVersion = new SearchResultVersion();
        resultVersion.setVersion(version);
        resultVersion.setDownloads(0L);
        resultVersion.setId(NugetRegistrationsUtils.registrationPageLeafId(repositoryUrl, id.toLowerCase(), version));
        searchResult.getVersions().add(resultVersion);
    }

    private static void populateRequiredFields(String repositoryUrl, Map<String, Object> assetNugetAttributes, SearchResult searchResult) {
        String id = (String)assetNugetAttributes.get("id");
        String version = (String)assetNugetAttributes.get("version");
        searchResult.setId(id);
        searchResult.setVersion(version);
        searchResult.setDescription((String)assetNugetAttributes.get("description"));
        String authors = (String)assetNugetAttributes.get("authors");
        if (StringUtils.isNotEmpty((CharSequence)authors)) {
            searchResult.setAuthors(Collections.singletonList(authors));
        }
        searchResult.setIconUrl((String)assetNugetAttributes.get("icon_url"));
        searchResult.setLicenseUrl((String)assetNugetAttributes.get("license_url"));
        searchResult.setProjectUrl((String)assetNugetAttributes.get("project_url"));
        searchResult.setSummary((String)assetNugetAttributes.get("summary"));
        String tags = (String)assetNugetAttributes.get("tags");
        if (StringUtils.isNotEmpty((CharSequence)tags)) {
            searchResult.setTags(NugetRegistrationsUtils.parseTags(tags));
        }
        searchResult.setTitle((String)assetNugetAttributes.get("title"));
        String registrationPageParent = NugetRegistrationsUtils.registrationPageParent(repositoryUrl, id.toLowerCase());
        searchResult.setRegistration(registrationPageParent);
        searchResult.setTotalDownloads(0L);
        searchResult.setVerified(false);
    }
}

