/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class NugetV3GroupServiceIndexHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public NugetV3GroupServiceIndexHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        ServiceIndex serviceIndex = ((NugetV3ServiceIndexFacet)context.getRepository().facet(NugetV3ServiceIndexFacet.class)).getServiceIndex();
        String json = this.objectMapper.writeValueAsString((Object)serviceIndex);
        return HttpResponses.ok((Payload)new StringPayload(json, "application/json"));
    }
}

