/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupAbstractHandler;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupHelper;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupMetadataManager;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupSearchFacet;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResponse;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

public class NugetV3GroupSearchHandler
extends NugetV3GroupAbstractHandler {
    public static final String SKIP = "skip";
    public static final String TAKE = "take";
    public static final int SKIP_DEFAULT_VALUE = 0;
    private NugetV3GroupMetadataManager metadataManager;
    private final int maxBucketSize;

    @Inject
    public NugetV3GroupSearchHandler(NugetV3GroupHelper nugetV3GroupHelper, NugetV3GroupMetadataManager metadataManager, @Named(value="${nexus.nuget.v3.search.maxBucketSize:-250}") int maxBucketSize) {
        super(nugetV3GroupHelper);
        this.metadataManager = metadataManager;
        this.maxBucketSize = maxBucketSize;
    }

    @Override
    @Nonnull
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Response.Builder builder = new Response.Builder().status(new Status(true, 200));
        Parameters parameters = context.getRequest().getParameters();
        int skip = parameters.contains(SKIP) ? Integer.parseInt(Objects.requireNonNull(parameters.get(SKIP))) : 0;
        int take = parameters.contains(TAKE) ? Integer.parseInt(Objects.requireNonNull(parameters.get(TAKE))) : this.maxBucketSize;
        int totalPackagesCount = Math.min(skip + take, this.maxBucketSize);
        List<Pair<Repository, Payload>> responses = this.getRepositoryPayloads(this.createContextToRequestMembers(context, totalPackagesCount), dispatched);
        Payload payload = this.mergeResponses(responses, context, skip, take);
        builder.payload(payload);
        return builder.build();
    }

    private Context createContextToRequestMembers(@Nonnull Context context, int totalPackagesCount) {
        Parameters parameters = this.copyParameters(context.getRequest().getParameters());
        parameters.replace(SKIP, new String[]{String.valueOf(0)});
        parameters.replace(TAKE, new String[]{String.valueOf(totalPackagesCount)});
        Request request = new Request.Builder().copy(context.getRequest()).parameters(parameters).build();
        Context newContext = new Context(context.getRepository(), request);
        context.getAttributes().forEach(att -> {
            Object object = newContext.getAttributes().set((String)att.getKey(), att.getValue());
        });
        return newContext;
    }

    private Parameters copyParameters(Parameters parameters) {
        Parameters copy = new Parameters();
        parameters.forEach(entry -> copy.set((String)entry.getKey(), new String[]{(String)entry.getValue()}));
        return copy;
    }

    private Payload mergeResponses(List<Pair<Repository, Payload>> payloads, Context context, int skip, int take) throws IOException {
        List<Pair<String, SearchResponse>> searchResponses = this.metadataManager.deserializeResponses(payloads, SearchResponse.class);
        NugetV3GroupSearchFacet facet = (NugetV3GroupSearchFacet)context.getRepository().facet(NugetV3GroupSearchFacet.class);
        SearchResponse mergedSearchResponse = facet.mergeResponse(searchResponses, skip, take);
        return this.metadataManager.toPayload(mergedSearchResponse);
    }
}

