/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.internal.exception.InvalidServiceIndexException;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.PackageBaseAddress;
import com.sonatype.nexus.repository.nuget.v3.models.PageLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationPage;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.inject.Named;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;

@Named
@Facet.Exposed
public class NugetV3GroupRegistrationPageFacet
extends FacetSupport {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public RegistrationPage rewritePage(Repository repository, RegistrationPage page, NugetServiceType groupServiceType, Context context) throws IOException {
        String sourceRegistrationUrl;
        if (page.getLeaves().isEmpty() && page.getCount() != 0) {
            RegistrationPage registrationPage = this.downloadRegistrationPage(repository, page.getId(), context);
            return this.rewritePage(repository, registrationPage, groupServiceType, context);
        }
        ServiceIndex serviceIndex = ((NugetV3ServiceIndexFacet)repository.facet(NugetV3ServiceIndexFacet.class)).getServiceIndex();
        try {
            sourceRegistrationUrl = serviceIndex.resourceIdByTypeTrimSlashes(groupServiceType);
        }
        catch (InvalidServiceIndexException invalidServiceIndexException) {
            this.log.debug("NuGet Repository {} is missing service {} in ServiceIndex, trying a fallback source registration URL", (Object)repository.getName(), (Object)groupServiceType.getType());
            sourceRegistrationUrl = String.valueOf(repository.getUrl()) + NugetV3ProxyUtil.trimSlashes(groupServiceType.getPath());
        }
        String groupRegistrationUrl = NugetV3ProxyUtil.joinPath(this.getRepository().getUrl(), groupServiceType.getPath());
        if (page.getParent() != null) {
            page.setParent(page.getParent().replace(sourceRegistrationUrl, groupRegistrationUrl));
        }
        if (page.getId() != null) {
            page.setId(page.getId().replace(sourceRegistrationUrl, groupRegistrationUrl));
        }
        for (PageLeaf pageLeaf : page.getLeaves()) {
            this.rewriteLeaf(repository, pageLeaf, serviceIndex, groupServiceType);
        }
        return page;
    }

    private RegistrationPage downloadRegistrationPage(Repository repository, String pageUrl, Context context) throws IOException {
        String registrationPagePath = new URL(pageUrl).getPath().replace(new URL(repository.getUrl()).getPath(), "");
        Request internalRequest = new Request.Builder().path(registrationPagePath).action("GET").build();
        ViewFacet viewFacet = (ViewFacet)repository.facet(ViewFacet.class);
        try {
            Response response = viewFacet.dispatch(internalRequest, context);
            if (response.getStatus().isSuccessful() && response.getPayload() != null) {
                return this.toRegistrationPage(new Content(response.getPayload()));
            }
            throw new IOException(String.format("Unable to download registration page %s from the repository %s, response was %s", registrationPagePath, repository.getName(), response));
        }
        catch (Exception e) {
            throw new IOException(String.format("Unable to download registration page %s from the repository %s", registrationPagePath, repository.getName()), e);
        }
    }

    private RegistrationPage toRegistrationPage(Content content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream contentStream = content.openInputStream();){
            return (RegistrationPage)objectMapper.readValue(contentStream, RegistrationPage.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void rewriteLeaf(Repository repository, PageLeaf pageLeaf, ServiceIndex serviceIndex, NugetServiceType groupServiceType) {
        String sourceContentUrl;
        String sourceRegistrationUrl;
        try {
            sourceRegistrationUrl = serviceIndex.resourceIdByTypeTrimSlashes(groupServiceType);
        }
        catch (InvalidServiceIndexException invalidServiceIndexException) {
            this.log.debug("NuGet Repository {} is missing service {} in ServiceIndex, trying a fallback source registration URL", (Object)repository.getName(), (Object)groupServiceType.getType());
            sourceRegistrationUrl = NugetV3ProxyUtil.joinPath(repository.getUrl(), NugetV3ProxyUtil.trimSlashes(groupServiceType.getPath()));
        }
        String groupRegistrationUrl = NugetV3ProxyUtil.joinPath(this.getRepository().getUrl(), groupServiceType.getPath());
        pageLeaf.setId(pageLeaf.getId().replace(sourceRegistrationUrl, groupRegistrationUrl));
        try {
            sourceContentUrl = serviceIndex.resourceIdByTypeTrimSlashes(PackageBaseAddress.PACKAGE_BASE_ADDRESS);
        }
        catch (InvalidServiceIndexException invalidServiceIndexException) {
            this.log.debug("NuGet Repository {} is missing service {} in ServiceIndex, trying a fallback source content URL", (Object)repository.getName(), (Object)groupServiceType.getType());
            sourceContentUrl = NugetV3ProxyUtil.joinPath(repository.getUrl(), NugetV3ProxyUtil.trimSlashes(PackageBaseAddress.PACKAGE_BASE_ADDRESS.getPath()));
        }
        String groupContentUrl = NugetV3ProxyUtil.joinPath(this.getRepository().getUrl(), PackageBaseAddress.PACKAGE_BASE_ADDRESS.getPath());
        pageLeaf.setPackageContent(pageLeaf.getPackageContent().replace(sourceContentUrl, groupContentUrl));
    }
}

