/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.collect.Lists;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupRegistrationPageFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SemVerLeafComparator;
import com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata.NugetRegistrationsUtils;
import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import com.sonatype.nexus.repository.nuget.v3.models.PageLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationPage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Context;

@Named
@Facet.Exposed
public class NugetV3GroupRegistrationIndexFacet
extends FacetSupport {
    public RegistrationIndex mergeResponses(List<Pair<Repository, RegistrationIndex>> responses, NugetServiceType serviceType, Context context) {
        List<RegistrationPage> pages = responses.stream().map(pair -> {
            try {
                return this.rewriteIndexes((Repository)pair.getKey(), (RegistrationIndex)pair.getValue(), serviceType, context);
            }
            catch (IOException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).filter(index -> index.getPages() != null).flatMap(index -> index.getPages().stream()).collect(Collectors.toList());
        List<RegistrationPage> mergedPages = this.mergePages(pages, serviceType);
        RegistrationIndex registrationIndex = new RegistrationIndex();
        registrationIndex.setPages(new ArrayList<RegistrationPage>(mergedPages));
        registrationIndex.setCount(mergedPages.size());
        return registrationIndex;
    }

    private RegistrationIndex rewriteIndexes(Repository repository, RegistrationIndex registrationIndex, NugetServiceType groupServiceType, Context context) throws IOException {
        NugetV3GroupRegistrationPageFacet pageFacet = (NugetV3GroupRegistrationPageFacet)this.facet(NugetV3GroupRegistrationPageFacet.class);
        RegistrationIndex newRegistrationIndex = new RegistrationIndex();
        newRegistrationIndex.setPages(new ArrayList<RegistrationPage>());
        for (RegistrationPage page : registrationIndex.getPages()) {
            RegistrationPage registrationPage = pageFacet.rewritePage(repository, page, groupServiceType, context);
            newRegistrationIndex.getPages().add(registrationPage);
        }
        newRegistrationIndex.setCount(newRegistrationIndex.getPages().size());
        return newRegistrationIndex;
    }

    private List<RegistrationPage> mergePages(List<RegistrationPage> pages, NugetServiceType serviceType) {
        if (pages.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Set> leafs = pages.stream().flatMap(registrationPage -> registrationPage.getLeaves().stream()).collect(Collectors.groupingBy(pageLeaf -> pageLeaf.getCatalogEntry().getId(), Collectors.toCollection(() -> new TreeSet<PageLeaf>(NugetV3SemVerLeafComparator.INSTANCE))));
        ArrayList<RegistrationPage> mergedPages = new ArrayList<RegistrationPage>();
        leafs.forEach((packageId, leaves) -> {
            List leafChunks = Lists.partition(new ArrayList(leaves), (int)64);
            leafChunks.forEach(chunk -> {
                RegistrationPage page = new RegistrationPage();
                page.setParent(NugetRegistrationsUtils.registrationPageParent(this.getRepository().getUrl(), packageId, serviceType));
                page.setLeaves((List<PageLeaf>)chunk);
                page.setCount(chunk.size());
                page.setLower(((PageLeaf)chunk.get(0)).getCatalogEntry().getVersion());
                page.setUpper(((PageLeaf)chunk.get(chunk.size() - 1)).getCatalogEntry().getVersion());
                page.setId(NugetV3ProxyUtil.joinPath(String.valueOf(page.getParent()) + "#page", page.getLower(), page.getUpper()));
                mergedPages.add(page);
            });
        });
        return mergedPages;
    }
}

