/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupAbstractHandler;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupHelper;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupMetadataManager;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupRegistrationIndexFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupRegistrationLeafFacet;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationLeaf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class NugetV3GroupRegistrationHandler
extends NugetV3GroupAbstractHandler {
    private final NugetV3GroupMetadataManager metadataManager;

    @Inject
    public NugetV3GroupRegistrationHandler(NugetV3GroupHelper nugetV3GroupHelper, NugetV3GroupMetadataManager metadataManager) {
        super(nugetV3GroupHelper);
        this.metadataManager = metadataManager;
    }

    @Override
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Payload payload;
        List<Pair<Repository, Payload>> repositoryPayloads = this.getRepositoryPayloads(context, dispatched);
        if (repositoryPayloads.isEmpty()) {
            return this.notFound();
        }
        NugetServiceType nugetServiceType = (NugetServiceType)Preconditions.checkNotNull((Object)((NugetServiceType)context.getAttributes().get(NugetServiceType.class)));
        AssetKind assetKind = (AssetKind)((Object)Preconditions.checkNotNull((Object)((Object)((AssetKind)((Object)context.getAttributes().get(AssetKind.class))))));
        switch (assetKind) {
            case REGISTRATION_INDEX: {
                List<Pair<Repository, RegistrationIndex>> registrationIndexes = this.metadataManager.deserializeResponsesWithServiceIndex(repositoryPayloads, RegistrationIndex.class);
                RegistrationIndex registrationIndex = this.mergeIndexes(registrationIndexes, nugetServiceType, context.getRepository(), context);
                payload = this.metadataManager.toPayload(registrationIndex);
                break;
            }
            case REGISTRATION_LEAF: {
                List<Pair<Repository, RegistrationLeaf>> registrationLeaves = this.metadataManager.deserializeResponsesWithServiceIndex(repositoryPayloads, RegistrationLeaf.class);
                RegistrationLeaf registrationLeaf = this.mergeLeaves(registrationLeaves, nugetServiceType, context.getRepository());
                payload = this.metadataManager.toPayload(registrationLeaf);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf((Object)assetKind));
            }
        }
        return HttpResponses.ok((Payload)payload);
    }

    private RegistrationIndex mergeIndexes(List<Pair<Repository, RegistrationIndex>> registrationIndexes, NugetServiceType nugetServiceType, Repository repository, Context context) {
        NugetV3GroupRegistrationIndexFacet registrationIndex = (NugetV3GroupRegistrationIndexFacet)repository.facet(NugetV3GroupRegistrationIndexFacet.class);
        return registrationIndex.mergeResponses(registrationIndexes, nugetServiceType, context);
    }

    private RegistrationLeaf mergeLeaves(List<Pair<Repository, RegistrationLeaf>> registrationLeaves, NugetServiceType nugetServiceType, Repository repository) {
        NugetV3GroupRegistrationLeafFacet registrationIndex = (NugetV3GroupRegistrationLeafFacet)repository.facet(NugetV3GroupRegistrationLeafFacet.class);
        return registrationIndex.mergeResponses(registrationLeaves, nugetServiceType);
    }
}

