/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupHandler;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupHelper;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupMetadataManager;
import com.sonatype.nexus.repository.nuget.v3.models.AvailableVersions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;

@Named
@Singleton
public class NugetV3GroupPackageVersionsHandler
extends NugetV3GroupHandler {
    private final NugetV3GroupMetadataManager metadataManager;

    @Inject
    public NugetV3GroupPackageVersionsHandler(NugetV3GroupHelper nugetV3GroupHelper, NugetV3GroupMetadataManager metadataManager) {
        super(nugetV3GroupHelper);
        this.metadataManager = metadataManager;
    }

    @Override
    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        List<Pair<Repository, Payload>> repositoryPayloads = this.getRepositoryPayloads(context, dispatched);
        if (repositoryPayloads.isEmpty()) {
            return this.notFound();
        }
        List<AvailableVersions> listOfAvailableVersions = this.metadataManager.deserializeResponsesTo(repositoryPayloads, AvailableVersions.class);
        AvailableVersions availableVersions = this.nugetV3GroupHelper.mergeAvailableVersions(listOfAvailableVersions);
        Payload payload = this.metadataManager.toPayload(availableVersions);
        return HttpResponses.ok((Payload)payload);
    }
}

