/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Named
@Singleton
public class NugetV3GroupMetadataManager
extends ComponentSupport {
    private final ObjectMapper objectMapper;

    @Inject
    public NugetV3GroupMetadataManager(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public <T> List<T> deserializeResponsesTo(List<Pair<Repository, Payload>> payloads, Class<T> clazz) {
        return payloads.stream().map(pair -> this.toDataObject((Payload)pair.getValue(), clazz)).collect(Collectors.toList());
    }

    public <T> List<Pair<String, T>> deserializeResponses(List<Pair<Repository, Payload>> payloads, Class<T> clazz) {
        return payloads.stream().map(pair -> Pair.of((Object)((Repository)pair.getKey()).getUrl(), this.toDataObject((Payload)pair.getValue(), clazz))).collect(Collectors.toList());
    }

    public <T> List<Pair<Repository, T>> deserializeResponsesWithServiceIndex(List<Pair<Repository, Payload>> payloads, Class<T> clazz) {
        return payloads.stream().map(pair -> ImmutablePair.of((Object)((Repository)pair.getKey()), this.toDataObject((Payload)pair.getValue(), clazz))).collect(Collectors.toList());
    }

    private <T> T toDataObject(Payload payload, Class<T> clazz) {
        Preconditions.checkNotNull((Object)payload);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream projectAsStream = payload.openInputStream();){
                return (T)this.objectMapper.readValue(projectAsStream, clazz);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public <T> Payload toPayload(T dataObject) throws IOException {
        return new BytesPayload(this.objectMapper.writeValueAsBytes(dataObject), "application/json");
    }
}

