/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.AvailableVersions;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.repository.Repository;

@Named
@Singleton
public class NugetV3GroupHelper
extends ComponentSupport {
    public List<Pair<Repository, List<String>>> getMembersRequestPaths(String requestPath, NugetServiceType serviceType, List<Repository> members) {
        List<Pair<Repository, List<String>>> membersServiceTypePaths = this.getMembersServiceTypePaths(serviceType, members);
        String requestPathSuffix = this.getRequestPathSuffix(requestPath, serviceType);
        return membersServiceTypePaths.stream().map(pair -> {
            List paths = (List)pair.getValue();
            List requestPaths = paths.stream().map(path -> this.toRequestPath((String)path, requestPathSuffix)).collect(Collectors.toList());
            return Pair.of((Object)((Repository)pair.getKey()), requestPaths);
        }).collect(Collectors.toList());
    }

    private String toRequestPath(String path, String requestPathSuffix) {
        return "/" + NugetV3ProxyUtil.joinPath(path, requestPathSuffix);
    }

    public String getRequestPathSuffix(String requestPath, NugetServiceType serviceType) {
        String serviceTypePath = serviceType.getPath();
        if (!requestPath.startsWith(serviceTypePath)) {
            throw new IllegalArgumentException(String.format("Request path %s does not start with service type path %s", requestPath, serviceTypePath));
        }
        return requestPath.substring(serviceTypePath.length());
    }

    public List<Pair<Repository, List<String>>> getMembersServiceTypePaths(NugetServiceType serviceType, List<Repository> members) {
        return members.stream().map(member -> Pair.of((Object)member, this.getPaths((Repository)member, serviceType))).collect(Collectors.toList());
    }

    private List<String> getPaths(Repository member, NugetServiceType serviceType) {
        Objects.requireNonNull(member);
        Objects.requireNonNull(serviceType);
        List<String> paths = this.getServiceIndex(member).map(ServiceIndex::getResources).map(resources -> resources.stream().filter(serviceResource -> serviceType.getType().equals(serviceResource.getType())).map(serviceResource -> {
            String id = serviceResource.getId();
            String url = member.getUrl();
            return id.replaceAll(url, "");
        }).collect(Collectors.toList())).orElse(Collections.emptyList());
        if (paths.isEmpty()) {
            this.log.debug("NuGet Repository {} is missing service {} in ServiceIndex, trying a fallback service path", (Object)member.getName(), (Object)serviceType.getType());
            paths = Collections.singletonList(serviceType.getPath());
        }
        return paths;
    }

    public Optional<ServiceIndex> getServiceIndex(Repository repository) {
        NugetV3ServiceIndexFacet serviceIndexFacet = (NugetV3ServiceIndexFacet)repository.facet(NugetV3ServiceIndexFacet.class);
        try {
            ServiceIndex serviceIndex = serviceIndexFacet.getServiceIndex();
            return Optional.of(serviceIndex);
        }
        catch (IOException e) {
            String repositoryName = repository.getName();
            this.log.warn("Error retrieving service index for the repository {}", (Object)repositoryName, (Object)e);
            return Optional.empty();
        }
    }

    public AvailableVersions mergeAvailableVersions(Collection<AvailableVersions> availableVersions) {
        Set versions = availableVersions.stream().flatMap(v -> v.getVersions().stream()).collect(Collectors.toCollection(() -> new TreeSet(VersionComparator.INSTANCE)));
        AvailableVersions result = new AvailableVersions();
        result.setVersions(new ArrayList<String>(versions));
        return result;
    }
}

