/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3HostedFacet;
import com.sonatype.nexus.repository.nuget.v3.models.AvailableVersions;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public class NugetPackageVersionsHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public NugetPackageVersionsHandler(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().get(TokenMatcher.State.class);
        String packageId = (String)state.getTokens().get("package_id");
        AvailableVersions availableVersions = ((NugetV3HostedFacet)context.getRepository().facet(NugetV3HostedFacet.class)).getPackageVersions(packageId);
        if (availableVersions != null && !availableVersions.getVersions().isEmpty()) {
            Response.Builder builder = new Response.Builder().status(new Status(true, 200));
            builder.payload(this.toPayload(availableVersions));
            return builder.build();
        }
        return new Response.Builder().status(new Status(false, 404, "The specified blob does not exist.")).build();
    }

    private Payload toPayload(AvailableVersions availableVersions) throws IOException {
        return new StringPayload(this.objectMapper.writeValueAsString((Object)availableVersions), "application/json");
    }
}

