/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3HostedFacet;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public class NugetPackageContentHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Map tokens = ((TokenMatcher.State)context.getAttributes().get(TokenMatcher.State.class)).getTokens();
        try {
            this.validateTokens(tokens, context.getRequest().getPath());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Response.Builder().status(new Status(false, 404, "The specified blob does not exist.")).build();
        }
        String packageId = (String)tokens.get("package_id");
        String version = (String)tokens.get("package_version");
        Optional<Content> content = ((NugetV3HostedFacet)context.getRepository().facet(NugetV3HostedFacet.class)).getAssetContent(packageId, version);
        if (content.isPresent()) {
            return new Response.Builder().status(new Status(true, 200)).payload((Payload)content.get()).build();
        }
        return new Response.Builder().status(new Status(false, 404, "The specified blob does not exist.")).build();
    }

    private void validateTokens(Map<String, String> tokens, String path) {
        String packageId = tokens.get("package_id");
        String packageIdPlusPackageVersion = tokens.get("package_id_plus_package_version");
        String package_version = tokens.get("package_version");
        if (!packageIdPlusPackageVersion.equals(String.valueOf(packageId) + "." + package_version)) {
            this.log.error("Requested package version or package id do not match: {}", (Object)path);
            throw new IllegalArgumentException();
        }
    }
}

