/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public class NugetHostedIndexServiceHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public NugetHostedIndexServiceHandler(ObjectMapper objectMapper) {
        this.objectMapper = (ObjectMapper)Preconditions.checkNotNull((Object)objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        ServiceIndex serviceIndex = ((NugetV3ServiceIndexFacet)context.getRepository().facet(NugetV3ServiceIndexFacet.class)).getServiceIndex();
        if (serviceIndex != null) {
            Response.Builder builder = new Response.Builder().status(new Status(true, 200));
            String method = context.getRequest().getAction();
            if (method != "HEAD") {
                builder.payload(this.toPayload(serviceIndex));
            }
            return builder.build();
        }
        String errorString = String.format("Internal error retrieving service index for repository %s.", context.getRepository().getName());
        return new Response.Builder().status(new Status(false, 500, errorString)).build();
    }

    private Payload toPayload(ServiceIndex serviceIndex) throws IOException {
        return new StringPayload(this.objectMapper.writeValueAsString((Object)serviceIndex), "application/json");
    }
}

