/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.codahale.metrics.health.HealthCheck;
import com.google.common.collect.Streams;
import com.sonatype.nexus.repository.nuget.NugetVersion;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named(value="NuGet V2 repositories")
@Singleton
public class NugetV2HealthCheck
extends HealthCheck {
    private final RepositoryManager repositoryManager;
    public static final String NUGET_V2_REPOS_PRESENT_ERROR = "Migrate the following NuGet version 2 repositories to NuGet version 3: %s";
    public static final String NUGET_V2_HEALTHY_MESSAGE = "No NuGet version 2 repositories found.";

    @Inject
    public NugetV2HealthCheck(RepositoryManager repositoryManager) {
        this.repositoryManager = repositoryManager;
    }

    protected HealthCheck.Result check() {
        List nugetV2RepositoriesNames = Streams.stream((Iterable)this.repositoryManager.browse()).filter(r -> "nuget".equals(r.getFormat().getValue())).filter(r -> NugetVersion.V2.name().equals(r.getConfiguration().attributes("nugetProxy").get("nugetVersion", String.class))).map(Repository::getName).collect(Collectors.toList());
        return nugetV2RepositoriesNames.isEmpty() ? HealthCheck.Result.healthy((String)NUGET_V2_HEALTHY_MESSAGE) : HealthCheck.Result.healthy((String)String.format(NUGET_V2_REPOS_PRESENT_ERROR, StringUtils.join(nugetV2RepositoriesNames, (String)", ")));
    }
}

