/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public abstract class NugetUploadHandlerSupport
extends UploadHandlerSupport {
    protected final ContentPermissionChecker contentPermissionChecker;
    protected final VariableResolverAdapter variableResolverAdapter;
    protected UploadDefinition definition;

    protected NugetUploadHandlerSupport(ContentPermissionChecker contentPermissionCheckerr, VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionCheckerr;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("nuget", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    protected Map<String, String> getMetadata(TempBlob tempBlob) throws IOException, NugetPackageException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = tempBlob.get();){
            return NugetPackageUtils.packageMetadata(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Map<String, String> getMetadata(Blob assetBlob) throws IOException, NugetPackageException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = assetBlob.getInputStream();){
            return NugetPackageUtils.packageMetadata(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Map<String, String> toMap(NugetPackageCoords coords) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", coords.getId());
        map.put("version", coords.getVersion());
        return map;
    }
}

