/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import java.util.Map;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public class NugetHandlerUtils {
    private NugetHandlerUtils() {
    }

    public static Response buildPackageResponse(Context context, Payload payload) {
        NugetPackageCoords coords = NugetHandlerUtils.getPackageCoordinates(context);
        return new Response.Builder().status(Status.success((int)200)).header("Content-Disposition", new String[]{String.format("attachment; filename=%s.%s.nupkg", coords.getId(), coords.getVersion())}).payload(payload).build();
    }

    public static NugetPackageCoords getPackageCoordinates(Context context) {
        Map tokens = ((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class)).getTokens();
        return new NugetPackageCoords((String)tokens.get("id"), (String)tokens.get("version"));
    }
}

