/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.sonatype.nexus.repository.nuget.NugetVersion;
import com.sonatype.nexus.repository.nuget.internal.NugetGroupVersionCheckFacetImpl;
import javax.annotation.Nonnull;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Response;

public abstract class NugetGroupVersionHandler
implements Handler {
    private NugetVersion nugetVersion;

    public NugetGroupVersionHandler(NugetVersion nugetVersion) {
        this.nugetVersion = nugetVersion;
    }

    public Response handle(@Nonnull Context context) throws Exception {
        Repository repository = context.getRepository();
        boolean versionSupported = ((NugetGroupVersionCheckFacetImpl)repository.facet(NugetGroupVersionCheckFacetImpl.class)).versionSupported(this.nugetVersion);
        if (!versionSupported) {
            return this.createVersionNotSupportedResponce(repository.getName());
        }
        return context.proceed();
    }

    protected Response createVersionNotSupportedResponce(String repositoryName) {
        return HttpResponses.badGateway((String)String.format("The group repository %s contains a proxy with different nuget version", repositoryName));
    }

    public static class NugetGroupVersionV2Handler
    extends NugetGroupVersionHandler {
        public NugetGroupVersionV2Handler() {
            super(NugetVersion.V2);
        }

        @Override
        public Response handle(@Nonnull Context context) throws Exception {
            Repository repository = context.getRepository();
            if ((String.valueOf(repository.getUrl()) + "index.json").endsWith(context.getRequest().getPath())) {
                return this.createVersionNotSupportedResponce(repository.getName());
            }
            return super.handle(context);
        }
    }

    public static class NugetGroupVersionV3Handler
    extends NugetGroupVersionHandler {
        public NugetGroupVersionV3Handler() {
            super(NugetVersion.V3);
        }
    }
}

