/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;

public final class NugetDataUtils {
    private static final Logger LOGGER = Loggers.getLogger(NugetDataUtils.class);

    private NugetDataUtils() {
    }

    public static boolean isPrerelease(Map<String, String> data) {
        return Boolean.parseBoolean(data.get("ISPRERELEASE")) || NugetDataUtils.isPrereleaseVersion(data.get("VERSION"));
    }

    private static boolean isPrereleaseVersion(String version) {
        return version.contains("-");
    }

    public static String normalizeVersion(Map<String, String> data) {
        return Optional.ofNullable(data.get("NORMALIZEDVERSION")).orElse(data.get("VERSION"));
    }

    public static String checkVersion(String version) {
        try {
            new GenericVersionScheme().parseVersion((String)Preconditions.checkNotNull((Object)version));
            return version;
        }
        catch (InvalidVersionSpecificationException e) {
            throw new IllegalArgumentException("Bad version syntax: " + version, e);
        }
    }

    public static Optional<String> buildNormalizeVersion(@Nullable String version) {
        if (StringUtils.isEmpty((CharSequence)version)) {
            return Optional.empty();
        }
        String releaseVersion = null;
        int metaIdx = version.indexOf("+");
        String baseVersion = metaIdx != -1 ? version.substring(0, metaIdx) : version;
        int dashIdx = baseVersion.indexOf(45);
        if (dashIdx != -1) {
            releaseVersion = baseVersion.substring(dashIdx + 1);
            baseVersion = baseVersion.substring(0, dashIdx);
        }
        try {
            return Optional.of(NugetDataUtils.buildNormalizedVersion(baseVersion, releaseVersion));
        }
        catch (NumberFormatException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private static String buildNormalizedVersion(String baseVersion, String releaseVersion) {
        String[] versionParts = baseVersion.split("\\.");
        StringBuilder versionBuilder = new StringBuilder();
        if (versionParts.length == 1) {
            versionBuilder.append(NugetDataUtils.trimLeadingZeros(versionParts[0])).append(".").append("0").append(".").append("0");
        }
        if (versionParts.length >= 2) {
            versionBuilder.append(NugetDataUtils.trimLeadingZeros(versionParts[0])).append(".");
            versionBuilder.append(NugetDataUtils.trimLeadingZeros(versionParts[1]));
            if (versionParts.length == 2) {
                versionBuilder.append(".").append("0");
            } else {
                String revision;
                versionBuilder.append(".").append(NugetDataUtils.trimLeadingZeros(versionParts[2]));
                if (versionParts.length == 4 && Integer.parseInt(revision = NugetDataUtils.trimLeadingZeros(versionParts[3])) > 0) {
                    versionBuilder.append(".").append(revision);
                }
            }
        }
        if (releaseVersion == null || releaseVersion.isEmpty()) {
            return versionBuilder.toString();
        }
        return versionBuilder.append("-").append(releaseVersion).toString();
    }

    private static String trimLeadingZeros(String versionPart) {
        return new Integer(versionPart).toString();
    }
}

