/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.internal.AbstractNugetHandler;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public abstract class AbstractNugetPushHandler
extends AbstractNugetHandler {
    private static final String EMPTY_HTMLDOC = "<html><body></body></html>";

    @Override
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        try {
            return this.doHandle(context);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            return this.convertToXmlError(e);
        }
    }

    @Override
    protected Response doHandle(Context context) throws Exception {
        Request request = context.getRequest();
        String action = request.getAction();
        if ("PUT".equals(action)) {
            return this.push(context, request);
        }
        return HttpResponses.methodNotAllowed((String)action, (String[])new String[]{"PUT"});
    }

    private Response push(@Nonnull Context context, Request request) throws IOException, NugetPackageException {
        Preconditions.checkArgument((boolean)request.isMultipart(), (Object)"Multipart request required");
        boolean created = false;
        Iterable multiparts = request.getMultiparts();
        for (Payload payload : multiparts) {
            this.storePayload(context, payload);
            created = true;
        }
        Preconditions.checkArgument((boolean)created, (Object)"No content was provided");
        return HttpResponses.created((Payload)new StringPayload(EMPTY_HTMLDOC, "text/html"));
    }

    protected abstract void storePayload(Context var1, Payload var2) throws IOException, NugetPackageException;
}

