/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.internal.NugetRepositoryBaseUrlSource;
import com.sonatype.nexus.repository.nuget.odata.ODataTemplates;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public abstract class AbstractNugetHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        try {
            return this.doHandle(context);
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (Exception e) {
            return this.convertToXmlError(e);
        }
    }

    protected abstract Response doHandle(Context var1) throws Exception;

    protected Response convertToXmlError(Exception e) {
        if (e instanceof NugetPackageException) {
            this.log.debug("Invalid package being uploaded", (Throwable)e);
            return this.xmlErrorMessage(400, e.getMessage());
        }
        if (e instanceof IllegalArgumentException) {
            this.log.debug("Bad argument", (Throwable)e);
            return this.xmlErrorMessage(400, e.getMessage());
        }
        if (e instanceof IllegalOperationException) {
            this.log.warn("Illegal operation", (Throwable)e);
            return this.xmlErrorMessage(400, e.getMessage());
        }
        if (e instanceof IOException) {
            this.log.warn("I/O exception", (Throwable)e);
            return this.xmlErrorMessage(500, "I/O exception");
        }
        this.log.error("Unknown error", (Throwable)e);
        return this.xmlErrorMessage(500, "Internal server error");
    }

    protected Response xmlErrorMessage(int code, String message) {
        return this.xmlPayload(code, this.populateErrorTemplate(code, message));
    }

    protected Response xmlPayload(int code, String content) {
        StringPayload stringPayload = new StringPayload(content, "application/xml");
        Status status = code < 300 ? Status.success((int)code) : Status.failure((int)code);
        return new Response.Builder().status(status).payload((Payload)stringPayload).build();
    }

    private String populateErrorTemplate(int code, String message) {
        ImmutableMap data = ImmutableMap.of((Object)"CODE", (Object)Integer.toString(code), (Object)"MESSAGE", (Object)Strings.nullToEmpty((String)message));
        return ODataTemplates.interpolate(ODataTemplates.NUGET_ERROR, data);
    }

    protected String getRepositoryBase(Context context) {
        NugetRepositoryBaseUrlSource repositoryBaseUrlSource = (NugetRepositoryBaseUrlSource)context.getRequest().getAttributes().getOrCreate(NugetRepositoryBaseUrlSource.class);
        return repositoryBaseUrlSource.get(context);
    }
}

