/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.nuget.datastore.NugetAssetUtils;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.datastore.internal.NugetV3ProxyRewriteUrlsMetadataProcessor;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.RepositoryEvent;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.maintenance.ContentMaintenanceFacet;
import org.sonatype.nexus.repository.manager.RepositoryUpdatedEvent;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.proxy.ProxyRepositoryConfiguration;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.scheduling.PeriodicJobService;

@Named
public class NugetV3ProxyServiceIndexFacet
extends FacetSupport
implements NugetV3ServiceIndexFacet {
    private final PeriodicJobService periodicJobService;
    private final NugetV3ProxyRewriteUrlsMetadataProcessor metadataProcessor;
    private Optional<PeriodicJobService.PeriodicJob> periodicJob = Optional.empty();

    @Inject
    public NugetV3ProxyServiceIndexFacet(PeriodicJobService periodicJobService, NugetV3ProxyRewriteUrlsMetadataProcessor metadataProcessor) {
        this.periodicJobService = (PeriodicJobService)Preconditions.checkNotNull((Object)periodicJobService);
        this.metadataProcessor = (NugetV3ProxyRewriteUrlsMetadataProcessor)Preconditions.checkNotNull((Object)metadataProcessor);
    }

    protected void doStop() throws Exception {
        this.periodicJob.ifPresent(PeriodicJobService.PeriodicJob::cancel);
        this.periodicJobService.stopUsing();
    }

    protected void doStart() throws Exception {
        this.periodicJobService.startUsing();
        this.getCachedServiceIndex().ifPresent(this::scheduleServiceIndexRefresh);
    }

    @VisibleForTesting
    static Optional<Duration> computeRefreshDelay(Content content, Duration metadataMaxAge) {
        return Optional.of(content).map(Content::getAttributes).map(attr -> (CacheInfo)attr.get(CacheInfo.class)).map(CacheInfo::getLastVerified).map(lastVerified -> lastVerified.plus(metadataMaxAge.toMillis())).map(BaseDateTime::getMillis).map(nextVerification -> nextVerification - DateTime.now().getMillis()).filter(delayMs -> delayMs > 0L).map(Duration::ofMillis).map(dly -> dly.plusSeconds(1L));
    }

    private void scheduleServiceIndexRefresh(Content content) {
        if (this.periodicJob.isPresent() || content == null) {
            return;
        }
        ProxyRepositoryConfiguration proxyConfiguration = ((ProxyFacet)this.getRepository().facet(ProxyFacet.class)).getConfiguration();
        NugetV3ProxyServiceIndexFacet.computeRefreshDelay(content, proxyConfiguration.getMetadataMaxAge()).ifPresent(refreshDelay -> {
            Duration refreshInterval = proxyConfiguration.getMetadataMaxAge().plusSeconds(1L);
            if (refreshInterval.compareTo(Duration.ofHours(1L)) < 0) {
                refreshInterval = Duration.ofHours(1L);
            }
            this.log.debug("Scheduling service reload in {} with interval {}", refreshDelay, (Object)refreshInterval);
            Runnable job = () -> {
                Object object = BaseUrlHolder.with((String)"http://localhost", (String)"/", this::refreshServiceIndex);
            };
            this.periodicJob = Optional.of(this.periodicJobService.schedule(job, refreshDelay, refreshInterval));
        });
    }

    protected Content refreshServiceIndex() {
        try {
            Context serviceIndexRequestContext = this.createServiceIndexRequestContext();
            Content content = ((ProxyFacet)this.facet(ProxyFacet.class)).get(serviceIndexRequestContext);
            this.scheduleServiceIndexRefresh(content);
            return content;
        }
        catch (Exception e) {
            this.log.warn("Failed to refresh service index on {}", (Object)this.getRepository().getName(), (Object)e);
            return null;
        }
    }

    private Context createServiceIndexRequestContext() {
        Request request = new Request.Builder().action("GET").path("/index.json").build();
        Context serviceIndexRequestContext = new Context(this.getRepository(), request);
        serviceIndexRequestContext.getAttributes().set(AssetKind.class, (Object)AssetKind.SERVICE_INDEX);
        return serviceIndexRequestContext;
    }

    @Override
    public ServiceIndex getServiceIndex() throws IOException {
        Content serviceIndexContent = this.getCachedServiceIndex().flatMap(this::rewriteServiceIndex).orElseGet(this::refreshServiceIndex);
        if (serviceIndexContent == null) {
            throw new IOException("Service Index unavailable");
        }
        return NugetAssetUtils.serialize((Payload)serviceIndexContent, ServiceIndex.class);
    }

    private Optional<Content> rewriteServiceIndex(Content content) {
        try {
            return Optional.of(this.metadataProcessor.rewriteUrls(this.createServiceIndexRequestContext(), content));
        }
        catch (IOException e) {
            this.log.debug("Failed to process cached service index for repository {}", (Object)this.getRepository().getName(), (Object)e);
            return Optional.empty();
        }
    }

    private Optional<Content> getCachedServiceIndex() throws IOException {
        return ((NugetContentFacet)this.facet(NugetContentFacet.class)).getServiceIndex();
    }

    @Override
    public void removeServiceIndex() {
        ((NugetContentFacet)this.facet(NugetContentFacet.class)).findAsset("/index.json").ifPresent(asset -> {
            Set set = ((ContentMaintenanceFacet)this.facet(ContentMaintenanceFacet.class)).deleteAsset((Asset)asset);
        });
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(RepositoryEvent event) {
        if (this.shouldRemoveServiceIndex(event)) {
            this.removeServiceIndex();
        }
    }

    private boolean shouldRemoveServiceIndex(RepositoryEvent event) {
        if (event.getRepository().getType() instanceof ProxyType && event instanceof RepositoryUpdatedEvent) {
            URI remoteUrl;
            String currentUrl;
            RepositoryUpdatedEvent updatedEvent = (RepositoryUpdatedEvent)event;
            Map oldConfiguration = updatedEvent.getOldConfiguration().getAttributes();
            if (oldConfiguration == null) {
                return false;
            }
            String previousUrl = NugetV3ProxyUtil.trimSlashes(((Map)oldConfiguration.get("proxy")).get("remoteUrl").toString());
            return !previousUrl.equals(currentUrl = NugetV3ProxyUtil.trimSlashes((remoteUrl = ((ProxyFacet)this.facet(ProxyFacet.class)).getRemoteUrl()).toString()));
        }
        return false;
    }
}

