/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.repository.nuget.datastore.NugetAssetUtils;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyRepositorySignaturesFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetMetadataMatcher;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationPage;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;

@Named
@Singleton
public class NugetV3ProxyRewriteUrlsMetadataProcessor {
    private static final Set<AssetKind> SUPPORTED_METADATA_KINDS = ImmutableSet.of((Object)((Object)AssetKind.SERVICE_INDEX), (Object)((Object)AssetKind.REGISTRATION_INDEX), (Object)((Object)AssetKind.REGISTRATION_PAGE), (Object)((Object)AssetKind.REGISTRATION_LEAF), (Object)((Object)AssetKind.REPOSITORY_SIGNATURES));

    public boolean isMetadataRewritable(AssetKind assetKind) {
        Objects.requireNonNull(assetKind);
        return SUPPORTED_METADATA_KINDS.contains((Object)assetKind);
    }

    public Content rewriteUrls(Context context, Content content) throws IOException {
        Objects.requireNonNull(context);
        Objects.requireNonNull(content);
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        String assetName = NugetAssetUtils.assetName(context);
        switch (assetKind) {
            case SERVICE_INDEX: {
                return this.rewriteServiceIndex(context, content);
            }
            case REGISTRATION_INDEX: {
                return this.rewriteRegistrationIndex(context, content);
            }
            case REGISTRATION_PAGE: {
                return this.rewriteRegistrationPage(context, content);
            }
            case REGISTRATION_LEAF: {
                return this.rewriteRegistrationLeaf(context, content);
            }
            case REPOSITORY_SIGNATURES: {
                return this.rewriteRepositorySignatures(context, content);
            }
        }
        throw new IllegalOperationException(String.format("Unsupported asset kind type %s for the asset %s", new Object[]{assetKind, assetName}));
    }

    private Content rewriteServiceIndex(Context context, Content content) throws IOException {
        ServiceIndex serviceIndex = NugetAssetUtils.serialize((Payload)content, ServiceIndex.class);
        ServiceIndex rewrittenServiceIndex = NugetV3ProxyUtil.buildNxrmServiceIndex(serviceIndex, context.getRepository().getUrl());
        Content rewrittenContent = NugetAssetUtils.asJsonContent(rewrittenServiceIndex);
        NugetAssetUtils.copyAttributes(content, rewrittenContent);
        return rewrittenContent;
    }

    private Content rewriteRepositorySignatures(Context context, Content content) {
        String repositorySignaturesPath = NugetMetadataMatcher.getRepositorySignaturesPath(context);
        return ((NugetV3ProxyRepositorySignaturesFacet)context.getRepository().facet(NugetV3ProxyRepositorySignaturesFacet.class)).rewriteRepositorySignaturesIndex(content, repositorySignaturesPath);
    }

    private Content rewriteRegistrationLeaf(Context context, Content content) throws IOException {
        RegistrationLeaf pageLeaf = NugetAssetUtils.serialize((Payload)content, RegistrationLeaf.class);
        ServiceIndex serviceIndex = (ServiceIndex)context.getAttributes().require(ServiceIndex.class);
        this.rewriteRegistrationLeafUrls(pageLeaf, serviceIndex);
        Content rewritten = NugetAssetUtils.asJsonContent(pageLeaf);
        NugetAssetUtils.copyAttributes(content, rewritten);
        return rewritten;
    }

    private Content rewriteRegistrationPage(Context context, Content content) throws IOException {
        RegistrationPage registrationPage = NugetAssetUtils.serialize((Payload)content, RegistrationPage.class);
        String repositoryUrl = context.getRepository().getUrl();
        ServiceIndex serviceIndex = (ServiceIndex)context.getAttributes().require(ServiceIndex.class);
        String registrationIndexUrl = NugetV3ProxyUtil.buildProxyUrl(registrationPage.getParent(), serviceIndex);
        this.rewriteRegistrationPageUrls(registrationPage, registrationIndexUrl, serviceIndex, repositoryUrl);
        Content rewritten = NugetAssetUtils.asJsonContent(registrationPage);
        NugetAssetUtils.copyAttributes(content, rewritten);
        return rewritten;
    }

    private Content rewriteRegistrationIndex(Context context, Content content) throws IOException {
        RegistrationIndex registrationIndex = NugetAssetUtils.serialize((Payload)content, RegistrationIndex.class);
        String assetName = NugetAssetUtils.assetName(context);
        String repositoryUrl = context.getRepository().getUrl();
        String registrationIndexUrl = String.valueOf(repositoryUrl) + assetName;
        ServiceIndex serviceIndex = (ServiceIndex)context.getAttributes().require(ServiceIndex.class);
        this.rewriteRegistrationIndexUrls(registrationIndex, registrationIndexUrl, serviceIndex, repositoryUrl);
        Content rewritten = NugetAssetUtils.asJsonContent(registrationIndex);
        NugetAssetUtils.copyAttributes(content, rewritten);
        return rewritten;
    }

    @VisibleForTesting
    void rewriteRegistrationIndexUrls(RegistrationIndex registrationIndex, String registrationIndexUrl, ServiceIndex serviceIndex, String repositoryUrl) {
        registrationIndex.getPages().forEach(p -> this.rewriteRegistrationPageUrls((RegistrationPage)p, registrationIndexUrl, serviceIndex, repositoryUrl));
    }

    @VisibleForTesting
    void rewriteRegistrationPageUrls(RegistrationPage page, String registrationIndexUrl, ServiceIndex serviceIndex, String repositoryUrl) {
        page.setParent(registrationIndexUrl);
        if (page.getId() != null) {
            page.setId(NugetV3ProxyUtil.rewritePageId(page.getId(), serviceIndex));
        }
        page.getLeaves().forEach(leaf -> NugetV3ProxyUtil.rewritePageLeafUrls(repositoryUrl, leaf, serviceIndex));
    }

    @VisibleForTesting
    void rewriteRegistrationLeafUrls(RegistrationLeaf leaf, ServiceIndex serviceIndex) {
        leaf.setId(NugetV3ProxyUtil.buildProxyUrl(leaf.getId(), serviceIndex));
        if (StringUtils.isNotBlank((CharSequence)leaf.getPackageContent())) {
            leaf.setPackageContent(NugetV3ProxyUtil.buildProxyUrl(leaf.getPackageContent(), serviceIndex));
        }
        if (StringUtils.isNotBlank((CharSequence)leaf.getRegistration())) {
            leaf.setRegistration(NugetV3ProxyUtil.buildProxyUrl(leaf.getRegistration(), serviceIndex));
        }
    }
}

