/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.datastore.NugetContentFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata.NugetRegistrationsFacet;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import java.io.InputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.event.component.ComponentEvent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

@Named
public class NugetRegistrationsFacetImpl
extends NugetRegistrationsFacet
implements EventAware.Asynchronous {
    @Inject
    public NugetRegistrationsFacetImpl(ObjectMapper mapper) {
        super(mapper);
    }

    @Override
    protected Collection<NugetRegistrationsFacet.ComponentContainer> getComponents(String packageId) {
        return ((NugetContentFacet)this.getRepository().facet(NugetContentFacet.class)).findComponents(packageId).stream().map(component -> {
            Optional<NestedAttributesMap> formatAttributesOptional = this.getFormatAttributes((FluentComponent)component);
            if (!formatAttributesOptional.isPresent()) {
                return null;
            }
            NestedAttributesMap attributes = formatAttributesOptional.get();
            return new NugetRegistrationsFacet.ComponentContainer(component.name(), component.version(), attributes);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    protected Optional<NugetRegistrationsFacet.ComponentContainer> getComponent(NugetPackageCoords coords) {
        return ((NugetContentFacet)this.getRepository().facet(NugetContentFacet.class)).findComponent(coords.getId(), coords.getVersion()).map(component -> {
            Optional<NestedAttributesMap> formatAttributesOptional = this.getFormatAttributes((FluentComponent)component);
            if (!formatAttributesOptional.isPresent()) {
                return null;
            }
            NestedAttributesMap attributes = formatAttributesOptional.get();
            return new NugetRegistrationsFacet.ComponentContainer(component.name(), component.version(), attributes);
        });
    }

    @Override
    protected Optional<RegistrationIndex> getCachedRegistrationIndex(String packageId) {
        Repository repository = this.getRepository();
        return ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(StringUtils.prependIfMissing((String)this.registrationIndexName(packageId), (CharSequence)"/", (CharSequence[])new CharSequence[0])).find().map(asset -> {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream is = asset.download().openInputStream();){
                    return (RegistrationIndex)this.mapper.readValue(is, RegistrationIndex.class);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.log.warn("Unable to read cached registration index for package: {} in repository: {}", new Object[]{packageId, repository.getName(), e});
                return null;
            }
        });
    }

    @Override
    protected void storePayload(Payload payload, String contentName) {
        ContentFacet contentFacet = (ContentFacet)this.getRepository().facet(ContentFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob blob = contentFacet.blobs().ingest(payload, NugetPackageUtils.HASH_ALGORITHMS);){
            contentFacet.assets().path(StringUtils.prependIfMissing((String)contentName, (CharSequence)"/", (CharSequence[])new CharSequence[0])).blob(blob).save();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected Optional<NestedAttributesMap> getFormatAttributes(FluentComponent fluentComponent) {
        return fluentComponent.assets().stream().findFirst().map(asset -> asset.attributes("nuget"));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void invalidateCachedRegistrationIndexOnComponentEvent(ComponentEvent event) {
        if (event.getRepository().map(Repository::getName).map(name -> name.equals(this.getRepository().getName())).orElse(false).booleanValue()) {
            ((ContentFacet)this.getRepository().facet(ContentFacet.class)).assets().path(StringUtils.prependIfMissing((String)this.registrationIndexName(event.getComponent().name()), (CharSequence)"/", (CharSequence[])new CharSequence[0])).find().ifPresent(FluentAsset::delete);
        }
    }
}

