/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.datastore.ContentNugetV3HostedFacet;
import com.sonatype.nexus.repository.nuget.internal.AbstractNugetPushHandler;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.security.SecurityFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class NugetPushHandler
extends AbstractNugetPushHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void storePayload(Context context, Payload payload) throws IOException, NugetPackageException {
        Repository repository = context.getRepository();
        ContentNugetV3HostedFacet hostedFacet = (ContentNugetV3HostedFacet)repository.facet(ContentNugetV3HostedFacet.class);
        ContentFacet contentFacet = (ContentFacet)repository.facet(ContentFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try {
            InputStream is = payload.openInputStream();
            try {
                try (TempBlob tempBlob = contentFacet.blobs().ingest(is, "application/zip", NugetPackageUtils.HASH_ALGORITHMS);){
                    Map<String, String> metadata;
                    Throwable throwable2 = null;
                    Object var12_15 = null;
                    try (InputStream in = tempBlob.get();){
                        metadata = NugetPackageUtils.packageMetadata(in);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                            throw throwable2;
                        } else {
                            if (throwable2 == throwable3) throw throwable2;
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                    this.ensurePermissions(context, metadata.get("ID"), metadata.get("VERSION"));
                    hostedFacet.put(metadata, tempBlob);
                }
                if (is == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private void ensurePermissions(Context context, String packageId, String version) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        String path = String.format("/%s/%s", packageId, version);
        Request changedRequest = new Request.Builder().copy(context.getRequest()).path(path).build();
        ((SecurityFacet)context.getRepository().facet(SecurityFacet.class)).ensurePermitted(changedRequest);
    }
}

